/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.PermissionRow;
import com.atlassian.webdriver.bitbucket.element.PermissionTable;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.PermissionsPage;

public class RepositoryPermissionsPage
extends BaseRepositoryPage
implements PermissionsPage {
    @ElementBy(id="user-permissions-table")
    private PermissionTable userPermissionTable;
    @ElementBy(id="group-permissions-table")
    private PermissionTable groupPermissionTable;
    @ElementBy(id="public-access-allowed")
    private AuiCheckbox publicAccessCheckbox;
    @ElementBy(cssSelector="#public-access-permission .submit-spinner")
    private PageElement publicAccessSubmitSpinner;

    public RepositoryPermissionsPage(String projectKey, String repoSlug) {
        super(projectKey, repoSlug);
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/permissions", this.projectKey, this.slug);
    }

    @Override
    public void doWait() {
        super.doWait();
        this.userPermissionTable.waitUntilLoaded();
        this.groupPermissionTable.waitUntilLoaded();
    }

    public RepositoryPermissionsPage setPublicAccess(boolean allowPublicAccess) {
        if (allowPublicAccess) {
            this.publicAccessCheckbox.check();
        } else if (this.publicAccessCheckbox.isChecked()) {
            this.publicAccessCheckbox.uncheck();
        }
        Poller.waitUntilFalse((TimedQuery)this.publicAccessSubmitSpinner.timed().isVisible());
        return this;
    }

    public boolean isPublicAccessSelected() {
        return this.publicAccessCheckbox.isChecked();
    }

    public boolean isPublicAccessEnabled() {
        return this.publicAccessCheckbox.isEnabled();
    }

    public PermissionRow getUserItem(String userId) {
        return this.userPermissionTable.getRow(userId);
    }

    public PermissionRow getGroupItem(String groupId) {
        return this.groupPermissionTable.getRow(groupId);
    }

    public void addGroups(String ... groups) {
        PermissionTable permissionsTable = this.getPermissionsTable(PermissionsPage.PermissionEntityType.GROUP);
        for (String group : groups) {
            permissionsTable = permissionsTable.selectItem(group);
        }
        permissionsTable.clickAdd();
    }

    public void addUsers(String ... users) {
        PermissionTable permissionsTable = this.getPermissionsTable(PermissionsPage.PermissionEntityType.USER);
        for (String user : users) {
            permissionsTable = permissionsTable.selectItem(user);
        }
        permissionsTable.clickAdd();
    }

    @Override
    public PermissionTable getPermissionsTable(PermissionsPage.PermissionEntityType entityType) {
        switch (entityType) {
            case USER: {
                return this.userPermissionTable;
            }
            case GROUP: {
                return this.groupPermissionTable;
            }
        }
        throw new UnsupportedOperationException();
    }
}

