/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.pageobjects.page.PullRequestOverviewPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.CommitList;
import com.atlassian.webdriver.bitbucket.element.PullRequestDetails;
import com.atlassian.webdriver.bitbucket.element.RefLozenge;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.element.SourceTargetSelector;
import com.atlassian.webdriver.bitbucket.page.FileBrowserPage;
import com.atlassian.webdriver.bitbucket.page.FormPage;
import java.util.List;
import org.openqa.selenium.By;

@Deprecated
public class PullRequestCreatePage
extends FormPage<PullRequestOverviewPage, FileBrowserPage> {
    private final String projectKey;
    private final String slug;
    @ElementBy(className="pull-request-details")
    private PullRequestDetails details;
    @ElementBy(id="submit-form")
    private PageElement submitButton;
    @ElementBy(id="show-create-pr-button")
    private PageElement continueButton;
    @ElementBy(cssSelector=".branch-change.show-hide-button")
    private PageElement changeButton;
    @ElementBy(className="commits-table", pageElementClass=CommitList.class)
    private CommitList commitList;
    @ElementBy(cssSelector=".aui-lozenge.source-branch")
    private RefLozenge sourceBranch;
    @ElementBy(cssSelector=".aui-lozenge.target-branch")
    private RefLozenge targetBranch;

    public PullRequestCreatePage(String projectKey, String slug) {
        this.projectKey = projectKey;
        this.slug = slug;
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/pull-requests?create", this.projectKey, this.slug);
    }

    public PullRequestDetails getDetails() {
        return this.details;
    }

    public boolean canCreate() {
        return this.submitButton.isEnabled();
    }

    public SearchableSelector getSourceRepositorySelector() {
        return ((SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0])).getSourceRepositorySelector();
    }

    public SearchableSelector getSourceBranchSelector() {
        return ((SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0])).getSourceBranchSelector();
    }

    public SearchableSelector getTargetRepositorySelector() {
        return ((SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0])).getTargetRepositorySelector();
    }

    public SearchableSelector getTargetBranchSelector() {
        return ((SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0])).getTargetBranchSelector();
    }

    public RefLozenge getCollapsedSourceBranch() {
        return this.sourceBranch;
    }

    public RefLozenge getCollapsedTargetBranch() {
        return this.targetBranch;
    }

    public PullRequestCreatePage clickContinue() {
        this.continueButton.click();
        return this;
    }

    public PullRequestCreatePage clickChange() {
        this.changeButton.click();
        return this;
    }

    public boolean isShowingPRForm() {
        return !this.continueButton.isVisible();
    }

    public CommitList getCommitList() {
        return this.commitList;
    }

    public PullRequestCreatePage clickSubmitExpectingErrors(Object ... args) {
        return (PullRequestCreatePage)super.clickSubmitExpectingErrors(this.projectKey, this.slug);
    }

    @Override
    public PullRequestOverviewPage clickSubmit(Object ... args) {
        return (PullRequestOverviewPage)super.clickSubmit(this.projectKey, this.slug, 0);
    }

    public List<String> getTitleFieldErrors() {
        return this.form.getFieldErrors("title");
    }

    public BuildStatusIcon getSourceBuildIcon() {
        return this.getBuildStatusIcon("source");
    }

    public BuildStatusIcon getTargetBuildIcon() {
        return this.getBuildStatusIcon("target");
    }

    private BuildStatusIcon getBuildStatusIcon(String selector) {
        PageElement icon = this.elementFinder.find(By.cssSelector((String)("#build-status-" + selector + "-selector .build-icon")));
        Poller.waitUntilTrue((TimedQuery)icon.timed().isVisible());
        return (BuildStatusIcon)this.pageBinder.bind(BuildStatusIcon.class, new Object[]{icon});
    }
}

