/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.PermissionRow;
import com.atlassian.webdriver.bitbucket.element.PermissionTable;
import com.atlassian.webdriver.bitbucket.page.BaseProjectPage;
import com.atlassian.webdriver.bitbucket.page.PermissionsPage;

public class ProjectPermissionsPage
extends BaseProjectPage
implements PermissionsPage {
    @ElementBy(id="licensed-users-permissions-readwrite")
    private AuiCheckbox allUsersReadWriteRadio;
    @ElementBy(id="licensed-users-permissions-read")
    private AuiCheckbox allUsersReadOnlyRadio;
    @ElementBy(id="licensed-users-permissions-none")
    private AuiCheckbox allUsersNoAccessRadio;
    @ElementBy(cssSelector="#licensed-users-permissions .submit-spinner")
    private PageElement allUsersSubmitSpinner;
    @ElementBy(id="public-access-allowed")
    private AuiCheckbox publicAccessCheckbox;
    @ElementBy(cssSelector="#public-access-permission .submit-spinner")
    private PageElement publicAccessSubmitSpinner;
    @ElementBy(id="user-permissions-table")
    private PermissionTable userPermissionTable;
    @ElementBy(id="group-permissions-table")
    private PermissionTable groupPermissionTable;

    public ProjectPermissionsPage(String key) {
        super(key);
    }

    public String getUrl() {
        return String.format("/projects/%s/permissions", this.getProjectKey());
    }

    @Override
    public void doWait() {
        super.doWait();
        this.userPermissionTable.waitUntilLoaded();
        this.groupPermissionTable.waitUntilLoaded();
    }

    public ProjectPermissionsPage selectAllUsersPerms(AllUsersPerms perms) {
        switch (perms) {
            case READ_WRITE: {
                this.allUsersReadWriteRadio.click();
                break;
            }
            case READ: {
                this.allUsersReadOnlyRadio.click();
                break;
            }
            case NONE: {
                this.allUsersNoAccessRadio.click();
            }
        }
        Poller.waitUntilFalse((TimedQuery)this.allUsersSubmitSpinner.timed().isVisible());
        return this;
    }

    public AllUsersPerms getPermissionsGrantedToAllLicensedUsers() {
        if (this.allUsersReadWriteRadio.isSelected()) {
            return AllUsersPerms.READ_WRITE;
        }
        if (this.allUsersReadOnlyRadio.isSelected()) {
            return AllUsersPerms.READ;
        }
        return AllUsersPerms.NONE;
    }

    public boolean isNoAccessPermissionDisabled() {
        return !this.allUsersNoAccessRadio.isEnabled();
    }

    public ProjectPermissionsPage setPublicAccess(boolean allowPublicAccess) {
        if (allowPublicAccess) {
            this.publicAccessCheckbox.select();
        } else if (this.publicAccessCheckbox.isSelected()) {
            this.publicAccessCheckbox.click();
        }
        Poller.waitUntilFalse((TimedQuery)this.publicAccessSubmitSpinner.timed().isVisible());
        return this;
    }

    public boolean isPublicAccessSelected() {
        return this.publicAccessCheckbox.isSelected();
    }

    public boolean isPublicAccessAvailable() {
        return this.publicAccessCheckbox.isVisible();
    }

    public PermissionRow getUserItem(String user) {
        return this.userPermissionTable.getRow(user);
    }

    @Override
    public PermissionTable getPermissionsTable(PermissionsPage.PermissionEntityType entityType) {
        switch (entityType) {
            case USER: {
                return this.userPermissionTable;
            }
            case GROUP: {
                return this.groupPermissionTable;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static enum AllUsersPerms {
        READ_WRITE,
        READ,
        NONE;

    }
}

