/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class AnnouncementAdminBannerPage
extends BitbucketPage {
    private static final String ALL = "ALL";
    private static final String AUTHENTICATED = "AUTHENTICATED";
    private static final String URL = "/admin/announcement-banner";
    @ElementBy(id="audience-authenticated")
    private AuiCheckbox authenticatedAudienceRadioButton;
    @ElementBy(cssSelector=".banner-preview .announcement-banner-content")
    private PageElement bannerPreview;
    @ElementBy(id="announcement-banner-enabled-off")
    private AuiCheckbox disableBannerRadioButton;
    @ElementBy(id="announcement-banner-enabled-on")
    private AuiCheckbox enableBannerRadioButton;
    @ElementBy(cssSelector="#announcement-banner-admin-container textarea")
    private PageElement messageTextArea;
    @ElementBy(cssSelector=".banner-preview .announcement-banner-content")
    private PageElement previewMessage;
    @ElementBy(id="audience-public")
    private AuiCheckbox publicAudienceRadioButton;
    @ElementBy(cssSelector="#announcement-banner-admin-container .aui-button-primary")
    private PageElement saveButton;

    public void clickSaveButton() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isEnabled());
        this.saveButton.click();
    }

    public String getAudience() {
        return this.authenticatedAudienceRadioButton.isSelected() ? AUTHENTICATED : ALL;
    }

    public void setAudience(String audience) {
        if (audience.equals(AUTHENTICATED)) {
            this.authenticatedAudienceRadioButton.select();
        } else {
            this.publicAudienceRadioButton.select();
        }
    }

    public boolean getEnabled() {
        return this.enableBannerRadioButton.isSelected();
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.enableBannerRadioButton.select();
        } else {
            this.disableBannerRadioButton.select();
        }
    }

    public String getMessage() {
        return this.messageTextArea.getValue();
    }

    public void setMessage(String textMessage) {
        this.messageTextArea.clear().type(new CharSequence[]{textMessage});
        Poller.waitUntil((TimedQuery)this.messageTextArea.timed().getText(), (Matcher)Matchers.equalTo((Object)textMessage));
    }

    public TimedQuery<String> getPreviewHtml() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ElementUtils.getHtml(this.getPreviewMessageElement()));
    }

    public PageElement getPreviewMessageElement() {
        return this.previewMessage.select();
    }

    public String getUrl() {
        return URL;
    }
}

