/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.matchers;

import com.atlassian.webdriver.bitbucket.page.admin.repo.AuditPage;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class AuditRowMatchers {
    private AuditRowMatchers() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static Matcher<AuditPage.AuditRow> withAffectedObject(final String affectedObject) {
        return new TypeSafeMatcher<AuditPage.AuditRow>(){
            private final Matcher<Iterable<? super AuditPage.AffectedObject>> affectedObjectsMatcher;
            {
                this.affectedObjectsMatcher = Matchers.hasItem((Matcher)AuditRowMatchers.withText(affectedObject));
            }

            protected void describeMismatchSafely(AuditPage.AuditRow item, Description mismatchDescription) {
                mismatchDescription.appendValue((Object)item);
            }

            public void describeTo(Description description) {
                description.appendText("with affected objects : ");
                this.affectedObjectsMatcher.describeTo(description);
            }

            protected boolean matchesSafely(AuditPage.AuditRow item) {
                return this.affectedObjectsMatcher.matches(item.getAffectedObjects());
            }
        };
    }

    public static Matcher<AuditPage.AuditRow> withAuthor(final String author) {
        return new TypeSafeMatcher<AuditPage.AuditRow>(){

            protected void describeMismatchSafely(AuditPage.AuditRow item, Description mismatchDescription) {
                mismatchDescription.appendValue((Object)item);
            }

            public void describeTo(Description description) {
                description.appendText("with author : " + author);
            }

            protected boolean matchesSafely(AuditPage.AuditRow item) {
                return item.getUsername().equalsIgnoreCase(author);
            }
        };
    }

    public static Matcher<AuditPage.AuditRow> withCategory(final String category) {
        return new TypeSafeMatcher<AuditPage.AuditRow>(){

            public void describeTo(Description description) {
                description.appendText("with category : " + category);
            }

            protected boolean matchesSafely(AuditPage.AuditRow item) {
                return item.getCategory().equalsIgnoreCase(category);
            }
        };
    }

    public static Matcher<AuditPage.AuditRow> withSummary(final String summary) {
        return new TypeSafeMatcher<AuditPage.AuditRow>(){

            public void describeTo(Description description) {
                description.appendText("with summary : " + summary);
            }

            protected boolean matchesSafely(AuditPage.AuditRow item) {
                return item.getSummary().equalsIgnoreCase(summary);
            }
        };
    }

    private static Matcher<AuditPage.AffectedObject> withText(final String text) {
        return new TypeSafeMatcher<AuditPage.AffectedObject>(){

            protected boolean matchesSafely(AuditPage.AffectedObject item) {
                return item.getText().equalsIgnoreCase(text);
            }

            protected void describeMismatchSafely(AuditPage.AffectedObject item, Description mismatchDescription) {
                mismatchDescription.appendValue((Object)item);
            }

            public void describeTo(Description description) {
                description.appendText("Affected object : " + text);
            }
        };
    }
}

