/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.requiredbuilds;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.requiredbuilds.RefMatcherEntry;
import com.atlassian.webdriver.bitbucket.element.requiredbuilds.RefMatcherListDisplay;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RequiredBuildsTable
extends AbstractElementPageObject {
    private final PageElement emptyState = this.find(By.className((String)"required-builds-empty-state"));
    private final PageElement loadingSpinner = this.find(By.className((String)"required-builds-spinner"));

    public RequiredBuildsTable(@Nonnull PageElement container) {
        super(container);
    }

    public boolean isEmpty() {
        Poller.waitUntilFalse((TimedQuery)this.isLoading());
        return this.emptyState.isPresent();
    }

    public TimedCondition isLoading() {
        return this.loadingSpinner.timed().isPresent();
    }

    public List<RequiredBuildsRow> getRows() {
        return this.container.findAll(By.className((String)"required-builds-row")).stream().map(ElementUtils.bind(this.pageBinder, RequiredBuildsRow.class, new Object[0])).collect(Collectors.toList());
    }

    public static class RequiredBuildsRow
    extends AbstractElementPageObject {
        private final PageElement actionsMenuBtn;
        private final PageElement buildKeys = this.find(By.className((String)"builds-col"));
        private final PageElement deleteButton;
        private final PageElement destinationRefMatch = this.find(By.className((String)"destinations-col"));
        private final PageElement editButton;
        private final PageElement exemptRefMatch = this.find(By.className((String)"exempt-sources-col"));

        public RequiredBuildsRow(@Nonnull PageElement container) {
            super(container);
            this.actionsMenuBtn = this.find(By.cssSelector((String)"[data-testid='actions-button']"));
            this.deleteButton = this.find(By.cssSelector((String)"[data-testid='delete-required-builds']"));
            this.editButton = this.find(By.cssSelector((String)"[data-testid='edit-required-builds']"));
        }

        public List<String> getBuildKeys() {
            return this.buildKeys.findAll(By.tagName((String)"li")).stream().map(PageElement::getText).collect(Collectors.toList());
        }

        public RefMatcherEntry getDestinationRefMatch() {
            RefMatcherListDisplay refMatcherListDisplay = (RefMatcherListDisplay)this.pageBinder.bind(RefMatcherListDisplay.class, new Object[]{this.destinationRefMatch});
            return refMatcherListDisplay.getRefMatch();
        }

        public RefMatcherEntry getExemptRefMatch() {
            RefMatcherListDisplay refMatcherListDisplay = (RefMatcherListDisplay)this.pageBinder.bind(RefMatcherListDisplay.class, new Object[]{this.exemptRefMatch});
            return refMatcherListDisplay.getRefMatch();
        }

        public void clickDelete() {
            this.actionsMenuBtn.click();
            this.deleteButton.click();
        }

        public void clickEdit() {
            this.actionsMenuBtn.click();
            this.editButton.click();
        }
    }
}

