/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.util.Locators;
import java.util.List;
import org.openqa.selenium.By;

public class FileTable
extends LegacyElementPageObject {
    public static final String ID = "browse-table";

    public FileTable(PageElement pageElement) {
        super(pageElement);
    }

    public FileTable(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public FileRow findByFileName(String fileName) {
        for (FileRow row : this.getRows()) {
            if (!row.getFileName().equals(fileName)) continue;
            return row;
        }
        return null;
    }

    public FileRow getFocusedRow() {
        return (FileRow)this.find(FileRow.FOCUSED_ROW_LOCATOR, FileRow.class);
    }

    public List<FileRow> getRows() {
        return this.findAll(Locators.tableRow(), FileRow.class);
    }

    public static class FileRow
    extends LegacyElementPageObject {
        static final By FOCUSED_ROW_LOCATOR = By.cssSelector((String)"tbody > tr.focused-file");

        public FileRow(PageElement pageElement) {
            super(pageElement);
        }

        public FileRow(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public FileRow(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public FileRow(By locator, WebDriverLocatable parent) {
            super(locator, parent, TimeoutType.DEFAULT);
        }

        public String getDescription() {
            return this.getDescriptionElement().getText();
        }

        public PageElement getDescriptionElement() {
            return this.find(By.cssSelector((String)"td.message > a"));
        }

        public String getFileName() {
            return this.getFileLink().getText();
        }

        public PageElement getFileLink() {
            return this.find(By.cssSelector((String)"a"));
        }
    }
}

