/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.Avatar;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class CommitList
extends LegacyElementPageObject {
    public CommitList(PageElement listContainer) {
        super(listContainer);
    }

    public CommitList(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public List<CommitListEntry> getRows() {
        return Chainable.chain((Iterable)this.findAll(Locators.tableRow())).transform(row -> (CommitListEntry)this.pageBinder.bind(CommitListEntry.class, new Object[]{row})).toList();
    }

    public List<String> getColumnNames() {
        List headers = this.findAll(By.tagName((String)"th"));
        return Lists.transform((List)headers, PageElement::getText);
    }

    public void loadNextPage() {
        ElementUtils.scrollDocumentAndWait((PageElement)this);
    }

    public static class JiraIssueColumnCell {
        private final PageElement cellElement;

        public JiraIssueColumnCell(PageElement cellElement) {
            this.cellElement = cellElement;
        }

        public String getTriggerText() {
            List a = this.cellElement.findAll(By.tagName((String)"a"), LinkElement.class);
            return ((LinkElement)((Object)a.get(0))).getText();
        }
    }

    public static class CommitListEntry {
        @Inject
        private PageBinder pageBinder;
        private final PageElement rowElement;

        public CommitListEntry(PageElement rowElement) {
            this.rowElement = rowElement;
        }

        public String getAuthor() {
            return this.rowElement.find(By.cssSelector((String)"td.author")).getText();
        }

        public Avatar getAuthorAvatar() {
            return (Avatar)this.rowElement.find(By.cssSelector((String)"td.author .user-avatar"), Avatar.class);
        }

        public String getMessage() {
            return this.rowElement.find(By.cssSelector((String)"td.message")).getText();
        }

        public String getCommitId() {
            return this.rowElement.find(By.cssSelector((String)"td.commit > a")).getText();
        }

        public String getCommitHash() {
            return ((LinkElement)this.rowElement.find(By.cssSelector((String)"td.commit > a"), LinkElement.class)).getUrl().replaceAll(".*?commits\\/", "");
        }

        public Boolean isMerge() {
            return this.rowElement.find(By.cssSelector((String)"td.commit > .merge-lozenge")).isPresent();
        }

        public String getMachineDate() {
            return this.rowElement.find(By.cssSelector((String)"td.timestamp > time")).getAttribute("datetime");
        }

        public String getCommitDate() {
            return this.rowElement.find(By.cssSelector((String)"td.timestamp > time")).getAttribute("title");
        }

        public <T> T getPluginColumn(int columnIndex, Class<T> columnClass) {
            return (T)this.pageBinder.bind(columnClass, new Object[]{this.rowElement.find(By.xpath((String)("td[" + (columnIndex + 1) + "]")))});
        }

        public boolean hasBuildStatus() {
            return this.rowElement.find(By.className((String)"build-icon")).isPresent();
        }

        public BuildStatusIcon getBuildStatusIcon() {
            PageElement buildIcon = this.rowElement.find(By.cssSelector((String)"td.build-status-commit-list-col > .build-icon"));
            return (BuildStatusIcon)this.pageBinder.bind(BuildStatusIcon.class, new Object[]{buildIcon});
        }
    }
}

