/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.activity;

import com.atlassian.bitbucket.pageobjects.element.activity.ActivityItem;
import com.atlassian.bitbucket.pageobjects.element.activity.CommentedActivityItem;
import com.atlassian.bitbucket.pageobjects.element.activity.MergedActivityItem;
import com.atlassian.bitbucket.pageobjects.element.activity.StateActivityItem;
import com.atlassian.bitbucket.pageobjects.element.activity.UpdatedActivityItem;
import com.atlassian.pageobjects.elements.PageElement;
import java.util.Arrays;
import java.util.function.Function;

public enum ActivityType {
    APPROVED(CommentedActivityItem.class, ActivityType.activityItemWithClass("approved-activity")),
    COMMENTED(CommentedActivityItem.class, ActivityType.activityItemWithClass("commented-activity")),
    DECLINED(StateActivityItem.class, ActivityType.activityItemWithClass("declined-activity")),
    NEEDS_WORK(StateActivityItem.class, ActivityType.activityItemWithClass("reviewed-activity")),
    MERGED(MergedActivityItem.class, ActivityType.activityItemWithClass("merged-activity")),
    OPENED(StateActivityItem.class, ActivityType.activityItemWithClass("opened-activity")),
    REOPENED(StateActivityItem.class, ActivityType.activityItemWithClass("reopened-activity")),
    UNAPPROVED(StateActivityItem.class, ActivityType.activityItemWithClass("unapproved-activity")),
    UPDATED(UpdatedActivityItem.class, ActivityType.activityItemWithClass("updated-activity"));

    private final Class<? extends ActivityItem> clazz;
    private final Function<PageElement, Boolean> matcher;

    private ActivityType(Class<? extends ActivityItem> clazz, Function<PageElement, Boolean> matcher) {
        this.clazz = clazz;
        this.matcher = matcher;
    }

    public static ActivityType fromPageElement(PageElement pageElement) {
        return Arrays.stream(ActivityType.values()).filter(activityType -> activityType.matcher.apply(pageElement)).findFirst().get();
    }

    public Class<? extends ActivityItem> getClazz() {
        return this.clazz;
    }

    private static Function<PageElement, Boolean> activityItemWithClass(String discriminatorClass) {
        return pageElement -> pageElement.getCssClasses().contains(discriminatorClass);
    }
}

