/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class ReactSelect
extends AbstractElementPageObject {
    private final String classNamePrefix;
    private final PageElement control;

    public ReactSelect(@Nonnull PageElement parentContainer, String classNamePrefix) {
        super(parentContainer);
        this.classNamePrefix = classNamePrefix;
        this.control = this.find(By.className((String)(classNamePrefix + "__control")));
    }

    public void selectOptionByName(String itemName) {
        PageElement matchingOption = this.getOptions().stream().filter(option -> itemName.equalsIgnoreCase(option.getText())).findFirst().orElse(null);
        matchingOption.click();
    }

    public void selectOptionByPartialName(String itemName) {
        PageElement matchingOption = this.getOptions().stream().filter(option -> option.getText().toLowerCase().contains(itemName.toLowerCase())).findFirst().orElse(null);
        matchingOption.click();
    }

    private List<PageElement> getOptions() {
        this.control.click();
        return this.container.findAll(By.className((String)(this.classNamePrefix + "__option")));
    }
}

