/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class PullRequestMergeDiagram
extends AbstractElementPageObject {
    @ElementBy(cssSelector=".merge-branches .ref-lozenge:nth-child(1)")
    protected PageElement sourceRef;
    @ElementBy(cssSelector=".merge-branches .ref-lozenge:nth-child(2)")
    protected PageElement targetRef;
    @ElementBy(cssSelector=".branches-diagram.auto-merge")
    protected PageElement autoMerge;

    public PullRequestMergeDiagram(@Nonnull PageElement container) {
        super(container);
    }

    public TimedQuery<List<String>> getAutoMergePath() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            if (!((Boolean)this.isAutoMerge().now()).booleanValue()) {
                return Collections.emptyList();
            }
            Iterable<PageElement> elements = this.findAll(By.cssSelector((String)".merge-branches .ref-lozenge:nth-child(n+3)"));
            return MoreStreams.streamIterable(elements).map(this::getRef).collect(Collectors.toList());
        });
    }

    public TimedQuery<String> getSourceRef() {
        return this.sourceRef.timed().getText();
    }

    public TimedQuery<String> getTargetRef() {
        return this.targetRef.timed().getText();
    }

    public TimedCondition isAutoMerge() {
        return this.autoMerge.timed().isPresent();
    }

    private String getRef(PageElement element) {
        return element.getText();
    }
}

