/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.CheckboxElement;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.BranchTypeConfigurationField;
import javax.inject.Inject;
import org.openqa.selenium.By;

public abstract class AbstractBranchModelSettingsPage
extends BaseSidebarPage {
    public static final String BUGFIX_TYPE_ID = "BUGFIX";
    public static final String FEATURE_TYPE_ID = "FEATURE";
    public static final String HOTFIX_TYPE_ID = "HOTFIX";
    public static final String RELEASE_TYPE_ID = "RELEASE";
    @ElementBy(id="branch-model-settings-form-submit")
    protected PageElement saveButton;
    @ElementBy(id="branch-model-automerge-enabled")
    protected CheckboxElement autoMerge;
    @ElementBy(id="branch-model-automerge-mergecheck-enabled")
    protected CheckboxElement autoMergeCheck;
    @ElementBy(className="aui-message-success")
    protected PageElement updateSuccessfulMessage;
    @ElementBy(id="branch-model-cancel")
    protected PageElement cancelLink;

    public AbstractBranchModelSettingsPage cancelChanges() {
        this.cancelLink.click();
        return this;
    }

    public AbstractBranchModelSettingsPage enableAutoMerge() {
        Poller.waitUntilTrue(this.isAutoMergeFieldEnabled());
        this.autoMerge.check();
        Poller.waitUntilTrue(this.isAutoMergeEnabled());
        return this;
    }

    public AbstractBranchModelSettingsPage enableAutoMergeCheck() {
        Poller.waitUntilTrue(this.isAutoMergeCheckFieldEnabled());
        this.autoMergeCheck.check();
        Poller.waitUntilTrue(this.isAutoMergeCheckEnabled());
        return this;
    }

    public BranchTypeConfigurationField getBranchTypeConfiguration(String branchTypeId) {
        return (BranchTypeConfigurationField)this.pageBinder.bind(BranchTypeConfigurationField.class, new Object[]{branchTypeId});
    }

    public abstract AbstractDevelopmentBranchConfiguration getDevelopmentConfiguration();

    public abstract AbstractProductionBranchConfiguration getProductionConfiguration();

    public TimedQuery<Boolean> isAutoMergeChecked() {
        return this.autoMerge.timed().isSelected();
    }

    public TimedQuery<Boolean> isAutoMergeEnabled() {
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.isAutoMergeFieldEnabled(), this.autoMerge.timed().isSelected()});
    }

    public TimedQuery<Boolean> isAutoMergeCheckEnabled() {
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.isAutoMergeCheckFieldEnabled(), this.autoMergeCheck.timed().isSelected()});
    }

    public TimedQuery<Boolean> isAutoMergeFieldEnabled() {
        return this.autoMerge.timed().isEnabled();
    }

    public TimedQuery<Boolean> isAutoMergeCheckFieldEnabled() {
        return this.autoMergeCheck.timed().isEnabled();
    }

    public boolean isSuccessfulUpdate() {
        return this.updateSuccessfulMessage.isPresent();
    }

    abstract AbstractBranchModelSettingsPage rebind();

    public AbstractBranchModelSettingsPage update() {
        this.saveButton.click();
        return this.rebind();
    }

    public static abstract class AbstractProductionBranchConfiguration
    extends AbstractBranchConfiguration {
        public AbstractProductionBranchConfiguration() {
            super("production");
        }

        private PageElement getNoProductionBranch() {
            return this.finder.find(By.id((String)"branch-model-production-type-none"));
        }

        public boolean isNoProductionBranch() {
            return this.getNoProductionBranch().hasAttribute("checked", "true");
        }

        public void selectNoProductionBranch() {
            this.getNoProductionBranch().select();
        }
    }

    public static abstract class AbstractDevelopmentBranchConfiguration
    extends AbstractBranchConfiguration {
        public AbstractDevelopmentBranchConfiguration() {
            super("development");
        }
    }

    public static abstract class AbstractBranchConfiguration {
        protected final String type;
        @Inject
        protected PageBinder pageBinder;
        @Inject
        protected PageElementFinder finder;

        public AbstractBranchConfiguration(String type) {
            this.type = type;
        }

        public abstract AbstractBranchConfiguration clearBranchNameField();

        public abstract TimedQuery<String> getBranchName();

        public PageElement getError() {
            return this.finder.find(By.cssSelector((String)("#branch-model-" + this.type + "-type + fieldset > .error")));
        }

        protected PageElement getUseBranchName() {
            return this.finder.find(By.id((String)("branch-model-" + this.type + "-type-branch-name")));
        }

        protected PageElement getUseDefaultBranch() {
            return this.finder.find(By.id((String)("branch-model-" + this.type + "-type-default")));
        }

        public boolean isUseDefaultBranch() {
            return this.getUseDefaultBranch().hasAttribute("checked", "true");
        }

        public AbstractBranchConfiguration selectUseBranchName() {
            Poller.waitUntilTrue((TimedQuery)this.getUseBranchName().select().timed().isSelected());
            return this;
        }

        public AbstractBranchConfiguration selectUseDefaultBranch() {
            Poller.waitUntilTrue((TimedQuery)this.getUseDefaultBranch().select().timed().isSelected());
            return this;
        }

        public abstract AbstractBranchConfiguration typeBranchName(String var1);
    }
}

