/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverCheckboxElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.UserEditPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import org.junit.Assert;
import org.openqa.selenium.By;

public class UserAddPage
extends BitbucketPage {
    @ElementBy(id="username")
    private PageElement usernameTextbox;
    @ElementBy(id="fullname")
    private PageElement fullnameTextbox;
    @ElementBy(id="email")
    private PageElement emailTextbox;
    @ElementBy(id="notify")
    private WebDriverCheckboxElement sendEmailCheckbox;
    @ElementBy(id="password")
    private PageElement passwordTextbox;
    @ElementBy(id="confirmPassword")
    private PageElement confirmPasswordTextbox;
    @ElementBy(id="createAnother")
    private WebDriverCheckboxElement createAnotherCheckbox;
    @ElementBy(cssSelector="input[type=submit]")
    private PageElement createButton;

    public String getUrl() {
        return "/admin/users?create";
    }

    public UserAddPage setUsername(String name) {
        return this.updateField(this.usernameTextbox, name);
    }

    public UserAddPage setFullname(String fullname) {
        return this.updateField(this.fullnameTextbox, fullname);
    }

    public UserAddPage setEmail(String email) {
        return this.updateField(this.emailTextbox, email);
    }

    public UserAddPage setPassword(String password) {
        return this.updatePasswordField(this.passwordTextbox, password);
    }

    public UserAddPage setConfirmPassword(String confirmPassword) {
        return this.updatePasswordField(this.confirmPasswordTextbox, confirmPassword);
    }

    public UserAddPage selectSendEmail(boolean select) {
        if (this.hasSendEmailCheckbox()) {
            return this.updateCheckbox(this.sendEmailCheckbox, select);
        }
        if (select) {
            Assert.fail((String)"No mail host configuration");
        }
        return this;
    }

    public UserAddPage selectCreateAnother(boolean select) {
        return this.updateCheckbox(this.createAnotherCheckbox, select);
    }

    public UserAddPage clearAllFields() {
        this.usernameTextbox.clear();
        this.fullnameTextbox.clear();
        this.emailTextbox.clear();
        this.selectSendEmail(false);
        this.passwordTextbox.clear();
        this.confirmPasswordTextbox.clear();
        return this;
    }

    public UserEditPage clickCreateSuccess() {
        this.createButton.click();
        return (UserEditPage)this.pageBinder.bind(UserEditPage.class, new Object[0]);
    }

    public UserAddPage clickCreateFail() {
        this.createButton.click();
        return this;
    }

    public Iterable<String> getFieldsWithErrors() {
        return ElementUtils.getFieldsWithErrors(this.body.find(By.cssSelector((String)"form.aui")));
    }

    private UserAddPage updateField(PageElement element, String text) {
        element.clear().type(new CharSequence[]{text});
        return this;
    }

    private UserAddPage updateCheckbox(WebDriverCheckboxElement checkbox, boolean select) {
        if (select) {
            checkbox.check();
        } else {
            checkbox.uncheck();
        }
        return this;
    }

    private UserAddPage updatePasswordField(PageElement element, String text) {
        element.type(new CharSequence[]{text});
        return this;
    }

    public boolean hasSendEmailCheckbox() {
        return this.sendEmailCheckbox.isPresent();
    }
}

