/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import org.openqa.selenium.By;

public class UserPasswordResetPage
extends BitbucketPage {
    public static final String URL = "/passwordreset";
    @ElementBy(cssSelector=".reset-password #identifier")
    private PageElement usernameOrEmailTextbox;
    @ElementBy(cssSelector=".reset-password #submit")
    private PageElement resetPasswordButton;

    public String getUrl() {
        return URL;
    }

    public boolean hasNoMailConfigError() {
        return !this.driver.findElements(By.cssSelector((String)".aui-message-error.no-mail-config")).isEmpty();
    }

    public boolean hasNoUserSubmittedError() {
        return !this.driver.findElements(By.cssSelector((String)".aui-message-error.user-empty")).isEmpty();
    }

    public boolean hasFormError() {
        return !this.driver.findElements(By.cssSelector((String)".aui-message-error")).isEmpty();
    }

    public boolean hasConfirmationThatEmailWasSent() {
        return !this.driver.findElements(By.cssSelector((String)".aui-message-success.reset-email-sent")).isEmpty();
    }

    public UserPasswordResetPage setUsernameOrEmail(String text) {
        this.usernameOrEmailTextbox.clear().type(new CharSequence[]{text});
        return this;
    }

    public UserPasswordResetPage clickResetPassword() {
        this.resetPasswordButton.click();
        return this;
    }
}

