/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.webdriver.bitbucket.page.PullRequestDiffPage;

public class PullRequestIterativeDiffPage
extends PullRequestDiffPage {
    private final String sinceHash;
    private final String untillHash;

    public PullRequestIterativeDiffPage(String projectKey, String slug, long pullRequestId, String sinceHash, String untilHash) {
        this(projectKey, slug, pullRequestId, sinceHash, untilHash, null);
    }

    public PullRequestIterativeDiffPage(String projectKey, String slug, long pullRequestId, String sinceHash, String untilHash, String path) {
        super(projectKey, slug, pullRequestId, path);
        this.sinceHash = sinceHash;
        this.untillHash = untilHash;
    }

    public PullRequestIterativeDiffPage(String projectKey, String slug, long pullRequestId, String sinceHash, String untilHash, long commentId, String action) {
        super(projectKey, slug, pullRequestId, commentId, action);
        this.sinceHash = sinceHash;
        this.untillHash = untilHash;
    }

    public String getSinceHash() {
        return this.sinceHash;
    }

    public String getUntillHash() {
        return this.untillHash;
    }

    @Override
    public PullRequestDiffPage toggleOverview() {
        this.switchToOverview();
        this.pullRequestTabs.clickDiffTab();
        return (PullRequestDiffPage)this.pageBinder.bind(PullRequestIterativeDiffPage.class, new Object[]{this.getProjectKey(), this.getSlug(), this.getPullRequestId(), this.sinceHash, this.untillHash});
    }

    @Override
    protected String getDiffUrl() {
        return "/commits/" + this.untillHash;
    }

    @Override
    protected String getExtraQueryParams() {
        return UrlUtils.buildQueryParams((Object[])new Object[]{"since", this.sinceHash});
    }
}

