/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AUISidebar;
import com.atlassian.webdriver.bitbucket.element.ProjectRepositoryTable;
import com.atlassian.webdriver.bitbucket.page.BaseProjectPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryCreatePage;
import com.atlassian.webdriver.bitbucket.page.RepositoryImportLandingPage;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ProjectOverviewPage
extends BaseProjectPage {
    private static final String CREATE_REPO_CLASSNAME = "create-repository-link";
    private static final String IMPORT_REPO_CLASSNAME = "import-repository-link";

    public ProjectOverviewPage(String key) {
        super(key);
    }

    public String getUrl() {
        return String.format("/projects/%s", this.getProjectKey());
    }

    public boolean canCreateRepository() {
        return this.getCreateRepositoryButton() != null;
    }

    public boolean canImportRepository() {
        return this.getImportRepositoryButton() != null;
    }

    public RepositoryCreatePage clickCreateRepository() {
        if (this.getCreateRepositoryButton() != null) {
            this.getCreateRepositoryButton().click();
            return (RepositoryCreatePage)this.pageBinder.bind(RepositoryCreatePage.class, new Object[]{this.getProjectKey()});
        }
        throw new IllegalStateException("Cannot click create repository button as it does not exist");
    }

    public RepositoryImportLandingPage clickImportRepository() {
        if (this.getImportRepositoryButton() != null) {
            this.getImportRepositoryButton().click();
            return (RepositoryImportLandingPage)this.pageBinder.bind(RepositoryImportLandingPage.class, new Object[]{this.getProjectKey()});
        }
        throw new IllegalStateException("Cannot click import repository button as it does not exist");
    }

    public ProjectRepositoryTable getRepositoryTable() {
        return (ProjectRepositoryTable)((Object)this.pageBinder.bind(ProjectRepositoryTable.class, new Object[]{By.cssSelector((String)".filterable-repository-table .entity-table"), TimeoutType.DEFAULT, this.getProjectKey()}));
    }

    public ProjectOverviewPage typeFilter(String filter) {
        PageElement input = this.elementFinder.find(By.className((String)"paged-table-filter-input"));
        Poller.waitUntilTrue((TimedQuery)input.timed().isVisible());
        input.type(new CharSequence[]{filter});
        Poller.waitUntil((TimedQuery)input.timed().getValue(), (Matcher)CoreMatchers.equalTo((Object)filter));
        return this;
    }

    private WebElement getCreateRepositoryButton() {
        this.openSidebar();
        List elements = this.driver.findElements(By.cssSelector((String)".create-repository-link a"));
        if (elements.size() > 0) {
            return (WebElement)elements.get(0);
        }
        return null;
    }

    private WebElement getImportRepositoryButton() {
        this.openSidebar();
        List elements = this.driver.findElements(By.cssSelector((String)".import-repository-link a"));
        if (elements.size() > 0) {
            return (WebElement)elements.get(0);
        }
        return null;
    }

    private void openSidebar() {
        AUISidebar sidebar = this.getSidebar();
        if (sidebar.isCollapsed()) {
            sidebar.toggle();
        }
    }
}

