/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.webdriver.bitbucket.element.FileBreadcrumbs;
import com.atlassian.webdriver.bitbucket.page.BranchLayoutPage;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public abstract class FileLayoutPage
extends BranchLayoutPage {
    protected final String path;
    protected final RevisionSpecifier revisionSpecifier;
    @ElementBy(className="breadcrumbs", pageElementClass=FileBreadcrumbs.class)
    private FileBreadcrumbs breadcrumbs;

    public FileLayoutPage(String projectKey, String repoSlug, String path) {
        this(projectKey, repoSlug, path, null);
    }

    public FileLayoutPage(String projectKey, String repoSlug, String path, RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug);
        this.revisionSpecifier = revisionSpecifier;
        this.path = !path.isEmpty() && !path.startsWith("/") ? "/" + path : path;
    }

    public FileBreadcrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    protected abstract String getPathComponent();

    public String getUrl() {
        String qs = "";
        if (this.revisionSpecifier != null) {
            String untilQs;
            String at = this.revisionSpecifier.at;
            String until = this.revisionSpecifier.until;
            String atQs = StringUtils.isNotBlank((CharSequence)at) ? "at=" + at : "";
            String string = untilQs = StringUtils.isNotBlank((CharSequence)until) ? "until=" + until : "";
            if (!StringUtils.isBlank((CharSequence)atQs) && !StringUtils.isBlank((CharSequence)untilQs)) {
                qs = "?" + atQs + "&" + untilQs;
            } else if (!StringUtils.isBlank((CharSequence)atQs)) {
                qs = "?" + atQs;
            } else if (!StringUtils.isBlank((CharSequence)untilQs)) {
                qs = "?" + untilQs;
            }
        }
        String repoUrl = this.projectKey.startsWith("~") ? "/users/" + this.projectKey.replace("~", "").toLowerCase(Locale.US) + "/repos/" + this.slug : "/projects/" + this.projectKey + "/repos/" + this.slug;
        return repoUrl + "/" + this.getPathComponent() + this.path + qs;
    }

    public static class RevisionSpecifier {
        public final String at;
        public final String until;

        public RevisionSpecifier(String at, String until) {
            this.until = until;
            this.at = at;
        }
    }
}

