/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.utils.by.ByDataAttribute;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class DiffSelectionDropdown {
    @Inject
    protected PageElementFinder elementFinder;
    @Inject
    protected PageElementActions actions;
    protected final PageElement trigger;

    public DiffSelectionDropdown(PageElement trigger) {
        this.trigger = trigger;
    }

    public DiffSelectionDropdown open() {
        AssertionError err = null;
        for (int i = 0; i < 5; ++i) {
            try {
                this.trigger.javascript().execute("window.scrollTo(document.documentElement.scrollWidth, 0);", new Object[0]);
                Poller.waitUntilTrue((TimedQuery)this.trigger.timed().isVisible());
                this.trigger.click();
                Poller.waitUntilTrue((TimedQuery)this.isOpen());
                return this;
            }
            catch (AssertionError e) {
                err = e;
                continue;
            }
        }
        throw err;
    }

    public TimedCondition isOpen() {
        return this.getDropdown().timed().isVisible();
    }

    public void selectUnified() {
        this.getDropdown().find(ByDataAttribute.byData((String)"value", (String)"unified")).click();
        Poller.waitUntilFalse((TimedQuery)this.isOpen());
    }

    public void selectSideBySide() {
        this.getDropdown().find(ByDataAttribute.byData((String)"value", (String)"side-by-side")).click();
        Poller.waitUntilFalse((TimedQuery)this.isOpen());
    }

    public void toggleHideComments() {
        this.getDropdown().find(ByDataAttribute.byData((String)"key", (String)"hideComments")).click();
        Poller.waitUntilFalse((TimedQuery)this.isOpen());
    }

    protected PageElement getDropdown() {
        String menuId = this.trigger.getAttribute("aria-controls");
        return this.elementFinder.find(By.id((String)menuId));
    }
}

