/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.CommitListPage;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;

public class BranchInfo {
    public static final Function<BranchInfoItem, String> TO_NAME = new Function<BranchInfoItem, String>(){

        public String apply(BranchInfoItem input) {
            return input.getName();
        }
    };
    private final PageElement element;
    private final String projectKey;
    private final String repoSlug;
    @Inject
    private PageBinder pageBinder;
    @Inject
    private PageElementFinder elementFinder;

    public BranchInfo(PageElement element, String projectKey, String repoSlug) {
        this.element = element;
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    @WaitUntil
    protected void waitForLoad() {
        Poller.waitUntilTrue((TimedQuery)this.element.timed().isPresent());
    }

    public BranchInfoItem getSingleBranch() {
        return (BranchInfoItem)this.pageBinder.bind(BranchInfoItem.class, new Object[]{this.element.find(By.className((String)"branch-info-branch-single")), this});
    }

    public BranchInfoDialog showMultipleBranches() {
        this.element.find(By.className((String)"branch-info-dropdown-trigger")).click();
        return (BranchInfoDialog)this.pageBinder.bind(BranchInfoDialog.class, new Object[]{this.elementFinder.find(By.id((String)"branch-info-dropdown")), this});
    }

    private CommitListPage openBranch(String branch) {
        return (CommitListPage)this.pageBinder.bind(CommitListPage.class, new Object[]{this.projectKey, this.repoSlug, branch});
    }

    public static class BranchInfoItem {
        private final PageElement element;
        private final BranchInfo parent;

        public BranchInfoItem(PageElement element, BranchInfo parent) {
            this.element = element;
            this.parent = parent;
        }

        public String getName() {
            return this.element.getText();
        }

        public CommitListPage click() {
            String branch = this.element.getText();
            this.element.click();
            return this.parent.openBranch(branch);
        }
    }

    public static class BranchInfoDialog {
        private final PageElement element;
        private final BranchInfo parent;
        @Inject
        private PageBinder pageBinder;

        public BranchInfoDialog(PageElement element, BranchInfo parent) {
            this.element = element;
            this.parent = parent;
        }

        @WaitUntil
        protected void waitForLoad() {
            Poller.waitUntilTrue((TimedQuery)this.element.timed().isVisible());
        }

        public List<BranchInfoItem> getBranches() {
            return Lists.transform((List)this.element.findAll(By.className((String)"branch-info-branch")), (Function)new Function<PageElement, BranchInfoItem>(){

                public BranchInfoItem apply(PageElement input) {
                    return (BranchInfoItem)pageBinder.bind(BranchInfoItem.class, new Object[]{input, parent});
                }
            });
        }
    }
}

