/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.search;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.google.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class SearchResultsPage
extends BitbucketPage {
    @Inject
    private PageBinder pageBinder;
    @ElementBy(className="search-results")
    private PageElement searchResults;

    public List<CodeSearchResult> getCodeResults() {
        return this.searchResults.findAll(By.cssSelector((String)"li.code-search-result")).stream().map(element -> (CodeSearchResult)this.pageBinder.bind(CodeSearchResult.class, new Object[]{element})).collect(Collectors.toList());
    }

    public String getUrl() {
        return "/plugins/servlet/search";
    }

    @WaitUntil
    public void ready() {
        Poller.waitUntilTrue((TimedQuery)this.searchResults.timed().isVisible());
    }

    public static class CodeSearchResult {
        @ElementBy(cssSelector="a.code-search-filename")
        protected PageElement fileNameLink;
        @ElementBy(cssSelector="div.code-search-repository")
        protected PageElement repositoryLink;

        public CodeSearchResult(PageElement selector) {
        }

        public String getFileName() {
            return this.fileNameLink.getText();
        }

        public String getRepoName() {
            return this.repositoryLink.getText();
        }
    }
}

