/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.AbstractBranchModelSettingsPage;
import org.openqa.selenium.By;

public class BranchModelProjectSettingsPage
extends AbstractBranchModelSettingsPage {
    private final String projectKey;

    public BranchModelProjectSettingsPage(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration getDevelopmentConfiguration() {
        return (AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration)this.pageBinder.bind(ProjectDevelopmentBranchConfiguration.class, new Object[0]);
    }

    @Override
    public AbstractBranchModelSettingsPage.AbstractProductionBranchConfiguration getProductionConfiguration() {
        return (AbstractBranchModelSettingsPage.AbstractProductionBranchConfiguration)this.pageBinder.bind(ProjectProductionBranchConfiguration.class, new Object[0]);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getUrl() {
        return "/plugins/servlet/branchmodel/projects/" + this.getProjectKey();
    }

    @Override
    BranchModelProjectSettingsPage rebind() {
        return (BranchModelProjectSettingsPage)this.pageBinder.bind(BranchModelProjectSettingsPage.class, new Object[]{this.getProjectKey()});
    }

    public static class ProjectProductionBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractProductionBranchConfiguration {
        @Override
        public AbstractBranchModelSettingsPage.AbstractBranchConfiguration clearBranchNameField() {
            this.getBranchNameField().clear();
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameField().timed().getValue();
        }

        private PageElement getBranchNameField() {
            return this.finder.find(By.id((String)("branch-model-" + this.type + "-field")));
        }

        @Override
        public AbstractBranchModelSettingsPage.AbstractBranchConfiguration typeBranchName(String name) {
            this.getBranchNameField().clear().type(new CharSequence[]{name});
            return this;
        }
    }

    public static class ProjectDevelopmentBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration {
        @Override
        public AbstractBranchModelSettingsPage.AbstractBranchConfiguration clearBranchNameField() {
            this.getBranchNameField().clear();
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameField().timed().getValue();
        }

        private PageElement getBranchNameField() {
            return this.finder.find(By.id((String)("branch-model-" + this.type + "-field")));
        }

        @Override
        public AbstractBranchModelSettingsPage.AbstractBranchConfiguration typeBranchName(String name) {
            this.getBranchNameField().clear().type(new CharSequence[]{name});
            return this;
        }
    }
}

