/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.DiffSelectionDropdown;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import org.openqa.selenium.By;

public class BaseCommitDiffPage
extends BaseRepositoryPage {
    @ElementBy(id="diff-options-dropdown-trigger")
    protected PageElement dropdown;
    @ElementBy(className="collapse-file-tree")
    protected PageElement collapseFileTreeButton;
    protected final String commit;

    public BaseCommitDiffPage(String projectKey, String slug, String commit) {
        super(projectKey, slug);
        this.commit = commit;
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/commits/" + this.commit;
    }

    public DiffSelectionDropdown openDropdownSelector() {
        return ((DiffSelectionDropdown)this.pageBinder.bind(DiffSelectionDropdown.class, new Object[]{this.dropdown})).open();
    }

    @WaitUntil
    public void diffLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.isFullyLoaded());
    }

    public TimedCondition isFullyLoaded() {
        return this.content.withTimeout(TimeoutType.COMPONENT_LOAD).find(By.className((String)"diff-view")).timed().hasClass("fully-loaded");
    }

    public String getCommit() {
        return this.commit;
    }

    public void collapseFileTree() {
        this.collapseFileTreeButton.click();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

