/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.label;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.webdriver.bitbucket.element.label.SimpleLabelEditor;
import com.atlassian.webdriver.bitbucket.page.label.LabelsForRepositoryDialog;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class LabelList {
    @Inject
    protected PageElementFinder elementFinder;
    @Inject
    protected PageBinder pageBinder;
    @ElementBy(className="empty-labels-input")
    private PageElement labelsInput;

    public List<Label> getLabels() {
        return (List)this.elementFinder.findAll(By.className((String)"aui-label")).stream().map(x$0 -> new Label((PageElement)x$0)).collect(MoreCollectors.toImmutableList());
    }

    public Label getLabelByName(String labelName) {
        return this.getLabels().stream().filter(label -> label.getLabelName().equals(labelName.toLowerCase())).findAny().orElse(null);
    }

    public SimpleLabelEditor editLabels() {
        this.labelsInput.click();
        return (SimpleLabelEditor)this.pageBinder.bind(SimpleLabelEditor.class, new Object[0]);
    }

    public class Label {
        private final PageElement labelLink;
        private final String labelName;

        public Label(PageElement pageElement) {
            this.labelLink = pageElement;
            this.labelName = this.labelLink.getText();
        }

        public String getLabelName() {
            return this.labelName;
        }

        public LabelsForRepositoryDialog clickLabel() {
            this.labelLink.click();
            return (LabelsForRepositoryDialog)((Object)LabelList.this.pageBinder.bind(LabelsForRepositoryDialog.class, new Object[]{this.getLabelName()}));
        }
    }
}

