/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AUIInlineDialog;
import com.google.common.base.Supplier;
import java.util.List;
import org.openqa.selenium.By;

public abstract class InfiniteScrollDialog<Item extends WebDriverElement>
extends AUIInlineDialog {
    public InfiniteScrollDialog(By triggerLocator, By inlineDialog) {
        super(triggerLocator, inlineDialog);
    }

    @Override
    public InfiniteScrollDialog open() {
        super.open();
        this.waitUntilPageLoaded();
        return this;
    }

    protected abstract Item findItem(String var1);

    protected abstract List<Item> getItems();

    public void clickItem(String itemName) {
        this.findItem(itemName).click();
    }

    public void clickItemAndWaitForClose(String itemName) {
        this.clickItem(itemName);
        Poller.waitUntilFalse((TimedQuery)this.timed().isVisible());
        Poller.waitUntilEquals((Object)itemName, (TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<String>(){

            public String get() {
                PageElement button = InfiniteScrollDialog.this.getTriggerPageElement();
                return InfiniteScrollDialog.this.getDropdownText(button);
            }
        }));
    }

    public String getTriggerText() {
        PageElement button = this.getTriggerPageElement();
        return this.getDropdownText(button);
    }

    protected String getDropdownText(PageElement button) {
        return button.find(By.className((String)"dropdown-text")).getText();
    }

    public abstract void loadNextPage();

    public abstract void waitUntilPageLoaded();
}

