/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import org.openqa.selenium.By;

public class AvatarPickerDialog<T extends BitbucketPage>
extends Dialog2 {
    @ElementBy(cssSelector=".image-upload-and-crop-container .faux-upload-field")
    private PageElement uploadField;
    @ElementBy(className="image-explorer-container")
    private PageElement imageContainer;
    private final T page;

    public AvatarPickerDialog(By locator, T page) {
        super(locator);
        this.page = page;
    }

    public AvatarPickerDialog(By locator, TimeoutType timeoutType, T page) {
        super(locator, timeoutType);
        this.page = page;
    }

    public AvatarPickerDialog<T> uploadImage(String imagePath) {
        return this.uploadImage(imagePath, false);
    }

    public AvatarPickerDialog<T> uploadImage(String imagePath, boolean waitForCompletion) {
        ElementUtils.uploadFile(this.uploadField, imagePath);
        if (waitForCompletion) {
            Poller.waitUntilFalse((TimedQuery)this.isImageEmpty());
        }
        return this;
    }

    public boolean hasErrors() {
        return this.find(By.className((String)"aui-message")).isPresent();
    }

    public TimedCondition isImageEmpty() {
        return this.imageContainer.timed().hasClass("empty");
    }

    public T clickDone() {
        this.clickMainAction();
        return this.page;
    }

    @Override
    By getCancelLinkLocator() {
        return By.className((String)"avatar-picker-cancel");
    }

    @Override
    By getMainActionLocator() {
        return By.className((String)"avatar-picker-save");
    }
}

