/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import org.openqa.selenium.By;

public class MirrorSupportToolsPage
extends BitbucketPage {
    private final String url;
    @ElementBy(cssSelector="div.ap-content iframe")
    private PageElement connectIFrame;

    public MirrorSupportToolsPage(String url) {
        this.url = url;
    }

    @WaitUntil
    public void ensurePageAndIFrameLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.connectIFrame.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        this.inConnectFrame(() -> {
            PageElement contentSelector = this.elementFinder.find(By.id((String)"content"));
            Poller.waitUntilTrue((TimedQuery)contentSelector.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        });
    }

    private void inConnectFrame(Runnable runnable) {
        this.driver.switchTo().frame(this.connectIFrame.getId());
        try {
            runnable.run();
        }
        finally {
            this.driver.switchTo().defaultContent();
        }
    }

    public String getUrl() {
        return this.url;
    }
}

