/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.accesstokens;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.page.accesstokens.AbstractAccessTokensPage;
import com.atlassian.webdriver.bitbucket.page.accesstokens.PermissionHelper;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class EditAccessTokenDialog
extends Dialog2 {
    @Inject
    protected PageElementFinder elementFinder;
    private final AbstractAccessTokensPage parentPage;

    public EditAccessTokenDialog(By locator, AbstractAccessTokensPage parentPage) {
        super(locator);
        this.parentPage = parentPage;
    }

    public EditAccessTokenDialog setTokenName(String newName) {
        PageElement nameField = this.find(By.id((String)"token-name"));
        nameField.clear().type(new CharSequence[]{newName});
        Poller.waitUntilEquals((Object)newName, (TimedQuery)nameField.timed().getValue());
        return this;
    }

    public EditAccessTokenDialog setProjectPermission(Permission newProjectPermission) {
        PermissionHelper.selectPermission(this.elementFinder, newProjectPermission);
        return this;
    }

    public EditAccessTokenDialog setRepositoryPermission(Permission newRepoPermission) {
        PermissionHelper.selectPermission(this.elementFinder, newRepoPermission);
        return this;
    }

    public AbstractAccessTokensPage saveAndClose() {
        PageElement editButton = this.find(By.cssSelector((String)".buttons-container .buttons :not(.aui-button-link)"));
        editButton.click();
        Poller.waitUntilFalse((TimedQuery)this.isOpen());
        return this.parentPage.rebind();
    }
}

