/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.DelayedBinder;
import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.google.common.base.Supplier;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenancePage
extends AbstractPage {
    private static final Logger log = LoggerFactory.getLogger(MaintenancePage.class);
    @ElementBy(className="cancel-link")
    private PageElement unlockLink;
    @ElementBy(id="cancel")
    private PageElement unlockButton;
    @ElementBy(id="cancelToken")
    private PageElement unlockToken;

    public String getUrl() {
        return "/unavailable";
    }

    public <P extends AbstractPage> P waitUntilCompleted(Class<P> nextPage, Object ... args) {
        final DelayedBinder delayedBinder = this.pageBinder.delayedBind(nextPage, args);
        try {
            Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){
                long lastLog = System.currentTimeMillis();
                long logEvery = TimeUnit.SECONDS.toMillis(5L);

                public Boolean get() {
                    if (log.isWarnEnabled() && System.currentTimeMillis() - this.logEvery > this.lastLog) {
                        this.lastLog = System.currentTimeMillis();
                        log.warn(String.format("Waiting for %s; got %s", ((AbstractPage)delayedBinder.get()).getUrl(), MaintenancePage.this.driver.getCurrentUrl()));
                    }
                    return AbstractPage.isOnPage(MaintenancePage.this.driver, (Page)delayedBinder.get());
                }
            }), (Matcher)Matchers.is((Object)true), (Poller.WaitTimeout)Poller.by((long)10L, (TimeUnit)TimeUnit.MINUTES));
        }
        catch (AssertionError e) {
            Assert.fail((String)String.format("Maintenance failed to complete and redirect.\n\t\tExpected: %s\n\t\tActual: %s", ((AbstractPage)delayedBinder.get()).getUrl(), this.driver.getCurrentUrl()));
        }
        return (P)((AbstractPage)delayedBinder.bind());
    }

    public TimedCondition hasUnlockLink() {
        return this.unlockLink.timed().isPresent();
    }

    public MaintenancePage clickUnlockLink() {
        this.unlockLink.click();
        return this;
    }

    public MaintenancePage setUnlockToken(String token) {
        this.unlockToken.type(new CharSequence[]{token});
        return this;
    }

    public MaintenancePage clickUnlockButton() {
        this.unlockButton.click();
        return this;
    }
}

