/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.SuggestedPullRequestRowCommits;
import com.atlassian.webdriver.bitbucket.page.PullRequestCreatePage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class SuggestedPullRequestRow
extends AbstractElementPageObject {
    private final PageElement commitsCount;
    private final PageElement commitsTable;
    private final PageElement pullRequestButton;
    private final PageElement expander;

    public SuggestedPullRequestRow(@Nonnull PageElement container) {
        super(container);
        this.expander = container.find(By.className((String)"table-expander"));
        this.commitsTable = container.find(By.className((String)"commits-table"));
        this.commitsCount = container.find(By.className((String)"commits-count"));
        this.pullRequestButton = container.find(By.cssSelector((String)".create-pr > a"));
    }

    public PullRequestCreatePage clickCreatePullRequest(String projectKey, String repoSlug) {
        this.pullRequestButton.timed().isPresent();
        this.pullRequestButton.click();
        return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{projectKey, repoSlug});
    }

    public void expand() {
        this.expander.timed().isPresent();
        this.expander.click();
        Poller.waitUntilTrue((TimedQuery)this.commitsTable.timed().isVisible());
    }

    public String getCommitCountText() {
        return (String)this.commitsCount.timed().getText().byDefaultTimeout();
    }

    public List<SuggestedPullRequestRowCommits> getCommits() {
        this.commitsTable.timed().isVisible();
        return this.commitsTable.findAll(By.tagName((String)"tr")).stream().map(ElementUtils.bind(this.pageBinder, SuggestedPullRequestRowCommits.class, new Object[0])).collect(Collectors.toList());
    }

    public String getPushedToBranch() {
        return (String)this.container.find(By.cssSelector((String)".description a.aui-button")).timed().getText().byDefaultTimeout();
    }
}

