/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.UserSelect;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class GroupUsersTable
extends AbstractElementPageObject {
    @Inject
    protected PageElementFinder elementFinder;
    @ElementBy(className="add-button")
    private PageElement addButton;
    private Long lastUpdated;
    private UserSelect userPicker;

    public GroupUsersTable(PageElement pageElement) {
        super(pageElement);
    }

    @WaitUntil
    protected void waitUntilLoaded() {
        ElementUtils.waitUntilUpdated(this.container, this.lastUpdated);
        this.lastUpdated = ElementUtils.getLastUpdated(this.container);
    }

    @Init
    protected void initUserPicker() {
        this.userPicker = (UserSelect)this.pageBinder.bind(UserSelect.class, new Object[]{this.container.find(By.className((String)"users-multi-selector"))});
    }

    public GroupUsersTable add(String name) {
        return this.add(name, false);
    }

    public GroupUsersTable add(String name, boolean expectError) {
        ((UserSelect)this.userPicker.type(name)).selectOption(name);
        if (!expectError) {
            this.waitUntilEventFired("bitbucket.internal.group.users.add.success", () -> this.addButton.click());
            this.waitUntilLoaded();
        } else {
            this.waitUntilEventFired("bitbucket.internal.group.users.add.failed", () -> this.addButton.click());
        }
        return this;
    }

    public GroupUsersTable remove(String name) {
        return this.remove(name, false);
    }

    public GroupUsersTable remove(String name, boolean expectError) {
        if (!expectError) {
            this.waitUntilEventFired("bitbucket.internal.group.users.remove.success", () -> this.find(name).clickDelete());
            this.waitUntilLoaded();
        } else {
            this.waitUntilEventFired("bitbucket.internal.group.users.remove.failed", () -> this.find(name).clickDelete());
        }
        return this;
    }

    public boolean canAdd(String name) {
        this.userPicker.type(name);
        boolean canAdd = (Boolean)this.userPicker.hasOption(option -> option != null && name.equals(option.getUsername())).byDefaultTimeout();
        this.userPicker.type(new CharSequence[]{Keys.ESCAPE});
        return canAdd;
    }

    public List<Row> list() {
        return this.container.findAll(By.cssSelector((String)"tbody > tr"), Row.class);
    }

    public Row find(String name) {
        return this.list().stream().filter(row -> row.getName().equals(name)).findFirst().orElse(null);
    }

    public static class Row
    extends LegacyElementPageObject {
        @ElementBy(cssSelector=".avatar-with-name > a")
        private PageElement name;
        @ElementBy(className="delete-button")
        private PageElement deleteButton;

        public Row(PageElement pageElement) {
            super(pageElement);
        }

        public Row(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public String getName() {
            return this.name.getText();
        }

        public void clickDelete() {
            ElementUtils.makeVisible(this.deleteButton);
            this.deleteButton.click();
        }
    }
}

