/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.storage;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.EmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectStreamingOutput;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ReadObjectRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.storage.HttpRange;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.http.mime.HostileExtensionDetector;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="/storage")
@Singleton
public class GitLfsStorageResource {
    private static final String IGNORED_SEPARATOR = "{ignored: /?}";
    private static final Logger log = LoggerFactory.getLogger(GitLfsStorageResource.class);
    private static final String OPTIONAL_NAMESPACE = "{namespace : (.*?)?}";
    private static final String OID_URI = "/{namespace : (.*?)?}{ignored: /?}{projectKey}/{repositorySlug}/{oid}";
    private final HostileExtensionDetector hostileExtensionDetector;
    private final I18nService i18nService;
    private final RepositoryService repositoryService;
    private final EmbeddedStoreService storeService;

    public GitLfsStorageResource(EmbeddedStoreService storeService, HostileExtensionDetector hostileExtensionDetector, I18nService i18nService, RepositoryService repositoryService) {
        this.storeService = storeService;
        this.hostileExtensionDetector = hostileExtensionDetector;
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/{namespace : (.*?)?}{ignored: /?}{projectKey}/{repositorySlug}/{oid}")
    public Response getObject(@PathParam(value="namespace") String namespace, @PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repositorySlug, @PathParam(value="oid") String oid, @HeaderParam(value="Range") String rangeHeader, @QueryParam(value="response-content-disposition") String responseContentDisposition, @QueryParam(value="response-content-type") String responseContentType) {
        Repository repository = this.repositoryService.getBySlug(StringUtils.trimToNull((String)namespace), projectKey, repositorySlug);
        if (repository == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo", new Object[]{projectKey, repositorySlug}), null);
        }
        Optional<HttpRange> parsedRange = HttpRange.parseRange(rangeHeader);
        if (rangeHeader != null && !parsedRange.isPresent()) {
            log.debug("HTTP range format invalid or unsupported");
        }
        ObjectStreamingOutput stream = this.storeService.readObject(new ReadObjectRequest.Builder(repository, oid).range(parsedRange.orElse(null)).build());
        Response.ResponseBuilder builder = stream.range().map(streamRange -> ResponseFactory.status((int)206).entity((Object)stream).header("Content-Range", (Object)String.format("bytes %s/*", streamRange))).orElse(ResponseFactory.ok().entity((Object)stream));
        if (StringUtils.isNotEmpty((CharSequence)responseContentDisposition)) {
            builder.header("Content-Disposition", (Object)responseContentDisposition);
        }
        if (StringUtils.isNotEmpty((CharSequence)responseContentType) && !this.hostileExtensionDetector.isExecutableContentType(responseContentType)) {
            builder.header("Content-Type", (Object)responseContentType);
        }
        return builder.build();
    }

    @PUT
    @Produces(value={"application/vnd.git-lfs+json; charset=utf-8"})
    @Path(value="/{namespace : (.*?)?}{ignored: /?}{projectKey}/{repositorySlug}/{oid}")
    public Response putObject(@Context Repository repository, @PathParam(value="oid") String oid, InputStream is) throws IOException {
        this.storeService.writeObject(repository, oid, is);
        return ResponseFactory.ok().build();
    }
}

