/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.DigestValidatingInputStream;
import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.internal.AbstractCacheEntry;
import com.atlassian.util.contentcache.internal.CacheWriteState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistingLfsCacheEntry
extends AbstractCacheEntry {
    private static final Logger log = LoggerFactory.getLogger(ExistingLfsCacheEntry.class);
    private final Path objectFile;

    protected ExistingLfsCacheEntry(@Nonnull String cacheKey, @Nonnull CacheExpiryStrategy cacheExpiryStrategy, @Nonnull Path objectFile) {
        super(cacheKey, "LFS", null, cacheExpiryStrategy, AbstractCacheEntry.State.AVAILABLE, CacheWriteState.COMPLETED);
        this.objectFile = Objects.requireNonNull(objectFile, "objectFile");
    }

    protected void doCleanup() {
    }

    @Nonnull
    protected InputStream doCreateCacheInputStream() throws IOException {
        return new DigestValidatingInputStream(Files.newInputStream(this.objectFile, new OpenOption[0]), this.objectFile);
    }

    @Nonnull
    protected OutputStream doCreateCacheOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                log.warn("Attempted to write to existing LFS cache entry {}", (Object)ExistingLfsCacheEntry.this.objectFile);
            }
        };
    }
}

