/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.LfsDigestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class DigestValidatingInputStream
extends DigestInputStream {
    private final String expectedChecksum;
    private final Path objectFile;

    public DigestValidatingInputStream(InputStream delegate, Path objectFile) {
        super(delegate, DigestUtils.getSha256Digest());
        this.objectFile = Objects.requireNonNull(objectFile, "objectFile");
        this.expectedChecksum = LfsFileSystemHelper.extractOid(objectFile);
    }

    public String getCalculatedChecksum() {
        return Hex.encodeHexString((byte[])this.digest.digest());
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result == -1) {
            LfsDigestUtils.validate(this.getCalculatedChecksum(), this.expectedChecksum, this.objectFile);
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch == -1) {
            LfsDigestUtils.validate(this.getCalculatedChecksum(), this.expectedChecksum, this.objectFile);
        }
        return ch;
    }
}

