/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.MirrorPluginNotAvailableException;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.UpstreamLfsClient;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchResponse;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.OperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestBatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestBatchResponse;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.NoSuchUpstreamException;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamAccount;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServerType;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamService;
import com.atlassian.bitbucket.mirroring.mirror.client.UpstreamClient;
import com.atlassian.bitbucket.mirroring.mirror.client.UpstreamClientFactory;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.bitbucket.util.IoUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.httpclient.api.DefaultResponseTransformation;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpstreamLfsClient
implements UpstreamLfsClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpstreamLfsClient.class);
    private static final String BATCH_CLOUD_URL_FORMAT = "/%s/%s.git/info/lfs/objects/batch";
    private static final String BATCH_SERVER_URL_FORMAT = "/scm/%s/%s.git/info/lfs/objects/batch";
    private static final Set<String> BATCH_UPLOAD_REQUEST_HEADERS = (Set)Stream.of("Authorization").map(DefaultUpstreamLfsClient::toLowerCase).collect(ImmutableSet.toImmutableSet());
    private static final Set<String> LOCK_PROXY_REQUEST_HEADERS = (Set)Stream.of("Authorization", "Content-Encoding", "Content-Language", "Content-Type").map(DefaultUpstreamLfsClient::toLowerCase).collect(ImmutableSet.toImmutableSet());
    private static final Set<String> LOCK_PROXY_RESPONSE_HEADERS = (Set)Stream.of("Allow", "Cache-Control", "Content-Disposition", "Content-Encoding", "Content-Language", "Content-Type", "Date", "ETag", "Expires", "Last-Modified", "Pragma", "Server", "Transfer-Encoding", "Vary").map(DefaultUpstreamLfsClient::toLowerCase).collect(ImmutableSet.toImmutableSet());
    private final ServiceTracker<UpstreamClientFactory, UpstreamClientFactory> clientFactoryTracker;
    private final I18nService i18nService;
    private final JsonRenderer jsonRenderer;
    private final RequestManager requestManager;
    private final ServiceTracker<UpstreamService, UpstreamService> upstreamServiceTracker;

    public DefaultUpstreamLfsClient(@Nonnull I18nService i18nService, @Nonnull JsonRenderer jsonRenderer, @Nonnull BundleContext context, @Nonnull RequestManager requestManager) {
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.jsonRenderer = Objects.requireNonNull(jsonRenderer, "jsonRenderer");
        this.requestManager = Objects.requireNonNull(requestManager, "requestManager");
        this.clientFactoryTracker = new ServiceTracker(context, "com.atlassian.bitbucket.mirroring.mirror.client.UpstreamClientFactory", null);
        this.clientFactoryTracker.open();
        this.upstreamServiceTracker = new ServiceTracker(context, "com.atlassian.bitbucket.mirroring.mirror.UpstreamService", null);
        this.upstreamServiceTracker.open();
    }

    public void destroy() {
        this.closeTracker(this.clientFactoryTracker);
        this.closeTracker(this.upstreamServiceTracker);
    }

    @Override
    public void proxyLockRequest(@Nonnull String lockPath, @Nonnull Repository repository) {
        Response upstreamResponse;
        Objects.requireNonNull(lockPath, "lockPath");
        Objects.requireNonNull(repository, "repository");
        UpstreamServer upstreamServer = this.getUpstreamServer();
        UpstreamClient upstreamClient = this.getUpstreamClient(upstreamServer);
        HttpServletRequest request = this.getHttpRequestOrFail();
        ImmutableListMultimap.Builder builder = new ImmutableListMultimap.Builder();
        request.getParameterMap().forEach((arg_0, arg_1) -> ((ImmutableListMultimap.Builder)builder).putAll(arg_0, arg_1));
        ImmutableListMultimap requestParams = builder.build();
        HttpServletResponse response = this.getHttpResponseOrFail();
        Request.Builder upstreamRequest = upstreamClient.newUnauthenticatedRequest(DefaultUpstreamLfsClient.lfsLockUrl(repository) + lockPath, (Multimap)requestParams).setCacheDisabled();
        try {
            this.copyLockProxyHeaders(request, upstreamRequest);
            this.copyEntity(request, upstreamRequest);
        }
        catch (IOException e) {
            log.error("Error copying LFS lock proxy request from client request", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            upstreamResponse = (Response)upstreamRequest.execute(Request.Method.valueOf((String)request.getMethod())).transform((ResponseTransformation)DefaultResponseTransformation.builder().done(r -> r).build()).claim();
        }
        catch (RuntimeException e) {
            log.error("Error executing LFS lock proxy request", (Throwable)e);
            throw e;
        }
        try {
            response.setStatus(upstreamResponse.getStatusCode());
            this.copyLockProxyHeaders(response, upstreamResponse);
            this.copyEntity(response, upstreamResponse);
            response.flushBuffer();
        }
        catch (IOException e) {
            log.error("Error copying proxy LFS lock response to client response", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public Optional<ResponseAction> proxyUploadRequest(@Nonnull Repository repository, @Nonnull RequestObject request) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(request, "request");
        UpstreamServer upstreamServer = this.getUpstreamServer();
        UpstreamClient upstreamClient = this.getUpstreamClient(upstreamServer);
        Response response = this.sendUploadRequest(repository, upstreamServer, upstreamClient, request);
        return DefaultUpstreamLfsClient.parseUploadAction(response.getEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestObject(@Nonnull Repository repository, @Nonnull String oid, @Nonnull OutputStream outputStream) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(oid, "oid");
        Objects.requireNonNull(outputStream, "outputStream");
        ResponseAction downloadAction = this.getDownloadAction(repository, oid);
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(downloadAction.getHref()).openConnection();
            downloadAction.getHeaders().forEach(urlConnection::setRequestProperty);
            try (InputStream in = urlConnection.getInputStream();
                 Timer ignored = TimerUtils.start((String)("Downloading git lfs file from upstream with oid:" + oid));){
                IoUtils.copy((InputStream)in, (OutputStream)outputStream);
            }
            finally {
                urlConnection.disconnect();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read LFS file " + oid + " from upstream", e);
        }
    }

    @VisibleForTesting
    static String batchUrl(Repository repository, UpstreamServer upstreamServer) {
        UpstreamServerType type = upstreamServer.getType();
        if (type == UpstreamServerType.BITBUCKET_CLOUD) {
            String teamName = upstreamServer.getAccount().map(UpstreamAccount::getName).orElseThrow(() -> new IllegalStateException("Failed to get the batch URL. A Bitbucket Cloud upstream must have an account specified."));
            return String.format(BATCH_CLOUD_URL_FORMAT, teamName, repository.getSlug());
        }
        if (type == UpstreamServerType.BITBUCKET_SERVER) {
            return String.format(BATCH_SERVER_URL_FORMAT, repository.getProject().getKey(), repository.getSlug());
        }
        throw new IllegalStateException("Unknown upstream type: " + type);
    }

    @VisibleForTesting
    static ResponseAction parseDownloadAction(String responseEntity) {
        ResponseObject responseObject = DefaultUpstreamLfsClient.parse(responseEntity).getObjects().stream().findFirst().orElseThrow(() -> new RuntimeException(String.format("Response [%s] does not contain any objects", responseEntity)));
        if (responseObject instanceof ResponseActionObject) {
            ResponseActionObject responseActionObject = (ResponseActionObject)responseObject;
            return responseActionObject.getAction(OperationType.DOWNLOAD).orElseThrow(() -> new RuntimeException(String.format("Response [%s] does not contain download action", responseEntity)));
        }
        throw new RuntimeException(String.format("Response [%s] contains error action", responseEntity));
    }

    @VisibleForTesting
    static Optional<ResponseAction> parseUploadAction(String responseEntity) {
        ResponseObject responseObject = DefaultUpstreamLfsClient.parse(responseEntity).getObjects().stream().findFirst().orElseThrow(() -> new RuntimeException(String.format("Response [%s] does not contain any objects", responseEntity)));
        if (responseObject instanceof ResponseActionObject) {
            ResponseActionObject responseActionObject = (ResponseActionObject)responseObject;
            return responseActionObject.getAction(OperationType.UPLOAD);
        }
        throw new RuntimeException(String.format("Response [%s] contains error action", responseEntity));
    }

    @Nonnull
    @VisibleForTesting
    ResponsePromise requestUpstreamActions(@Nonnull UpstreamClient upstreamClient, @Nonnull UpstreamServer upstreamServer, @Nonnull Repository repository, @Nonnull String oid) {
        long ignored = 0L;
        RestBatchRequest batchRequest = new RestBatchRequest(new BatchRequest(OperationType.DOWNLOAD, Collections.singleton(new RequestObject(oid, ignored))));
        return ((Request.Builder)((Request.Builder)upstreamClient.newScmHttpRequest(DefaultUpstreamLfsClient.batchUrl(repository, upstreamServer)).setContentType("application/json")).setEntity(this.jsonRenderer.render((Object)batchRequest, Collections.emptyMap()))).post();
    }

    @Nonnull
    @VisibleForTesting
    Response sendUploadRequest(@Nonnull Repository repository, @Nonnull UpstreamServer upstreamServer, @Nonnull UpstreamClient upstreamClient, @Nonnull RequestObject request) {
        RestBatchRequest batchRequest = new RestBatchRequest(new BatchRequest(OperationType.UPLOAD, Collections.singleton(request)));
        Request.Builder requestBuilder = (Request.Builder)((Request.Builder)upstreamClient.newUnauthenticatedRequest(DefaultUpstreamLfsClient.batchUrl(repository, upstreamServer)).setContentType("application/json")).setEntity(this.jsonRenderer.render((Object)batchRequest, Collections.emptyMap()));
        this.copyHeaders(this.getHttpRequestOrFail(), requestBuilder, BATCH_UPLOAD_REQUEST_HEADERS);
        return (Response)requestBuilder.post().claim();
    }

    private static String lfsLockUrl(@Nonnull Repository repository) {
        return DefaultUpstreamLfsClient.lfsUrl(repository) + "/locks";
    }

    private static String lfsUrl(@Nonnull Repository repository) {
        return RepositoryUrlFragment.fromRepository((Repository)repository).toPath("/scm", false, false) + ".git/info/lfs";
    }

    private static IllegalStateException newNoRequestInScopeException() {
        return new IllegalStateException("No request in scope");
    }

    private static IllegalStateException newNoResponseInScopeException() {
        return new IllegalStateException("No response in scope");
    }

    @Nonnull
    private static BatchResponse parse(String entity) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return ((RestBatchResponse)((Object)mapper.readValue(entity, RestBatchResponse.class))).fromRest();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to deserialize an instance of RestBatchResponse from the response [%s]", entity), e);
        }
    }

    private static String toLowerCase(String value) {
        return value.toLowerCase(Locale.ROOT);
    }

    @Nonnull
    private static <T> Optional<T> tryOptionally(@Nonnull Callable<T> callable, Class<? extends Exception> ... expectedExceptions) {
        Objects.requireNonNull(callable, "callable");
        try {
            return Optional.ofNullable(callable.call());
        }
        catch (Exception e) {
            if (Arrays.stream(expectedExceptions).anyMatch(expectedException -> expectedException.isAssignableFrom(e.getClass()))) {
                return Optional.empty();
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void closeTracker(ServiceTracker tracker) {
        if (tracker != null) {
            tracker.close();
        }
    }

    private void copyEntity(HttpServletRequest request, Request.Builder upstreamRequest) throws IOException {
        ServletInputStream requestInputStream = request.getInputStream();
        if (!requestInputStream.isFinished()) {
            upstreamRequest.setEntityStream((InputStream)requestInputStream, Optional.ofNullable(request.getContentType()).flatMap(contentType -> DefaultUpstreamLfsClient.tryOptionally(() -> MediaType.parse((String)contentType), IllegalArgumentException.class)).map(MediaType::charset).flatMap(o -> com.google.common.base.Optional.toJavaUtil((com.google.common.base.Optional)o)).map(Charset::name).orElse("UTF-8"));
        }
    }

    private void copyEntity(HttpServletResponse response, Response upstreamResponse) throws IOException {
        try (ServletOutputStream responseOutputStream = response.getOutputStream();){
            IoUtils.copy((InputStream)upstreamResponse.getEntityStream(), (OutputStream)responseOutputStream);
            responseOutputStream.flush();
        }
    }

    private void copyLockProxyHeaders(HttpServletRequest request, Request.Builder requestBuilder) {
        this.copyHeaders(request, requestBuilder, LOCK_PROXY_REQUEST_HEADERS);
    }

    private void copyLockProxyHeaders(HttpServletResponse response, Response upstreamResponse) {
        this.copyHeaders(response, upstreamResponse, LOCK_PROXY_RESPONSE_HEADERS);
    }

    private void copyHeaders(HttpServletRequest request, Request.Builder requestBuilder, Set<String> whiteList) {
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (!whiteList.contains(DefaultUpstreamLfsClient.toLowerCase(header))) continue;
            requestBuilder.setHeader(header, request.getHeader(header));
        }
    }

    private void copyHeaders(HttpServletResponse response, Response upstreamResponse, Set<String> whiteList) {
        Map headers = upstreamResponse.getHeaders();
        headers.entrySet().stream().filter(entry -> whiteList.contains(DefaultUpstreamLfsClient.toLowerCase((String)entry.getKey()))).forEach(entry -> response.setHeader((String)entry.getKey(), (String)entry.getValue()));
    }

    private ResponseAction getDownloadAction(Repository repository, String oid) {
        UpstreamServer upstreamServer = this.getUpstreamServer();
        UpstreamClient upstreamClient = this.getUpstreamClient(upstreamServer);
        String responseEntity = ((Response)this.requestUpstreamActions(upstreamClient, upstreamServer, repository, oid).claim()).getEntity();
        return DefaultUpstreamLfsClient.parseDownloadAction(responseEntity);
    }

    private Optional<HttpServletRequest> getHttpRequest() {
        return Optional.ofNullable(this.requestManager.getRequestContext()).map(RequestInfoProvider::getRawRequest).filter(rawRequest -> HttpServletRequest.class.isAssignableFrom(rawRequest.getClass())).map(HttpServletRequest.class::cast);
    }

    private HttpServletRequest getHttpRequestOrFail() {
        return this.getHttpRequest().orElseThrow(DefaultUpstreamLfsClient::newNoRequestInScopeException);
    }

    private Optional<HttpServletResponse> getHttpResponse() {
        return Optional.ofNullable(this.requestManager.getRequestContext()).map(RequestInfoProvider::getRawResponse).filter(rawResponse -> HttpServletResponse.class.isAssignableFrom(rawResponse.getClass())).map(HttpServletResponse.class::cast);
    }

    private HttpServletResponse getHttpResponseOrFail() {
        return this.getHttpResponse().orElseThrow(DefaultUpstreamLfsClient::newNoResponseInScopeException);
    }

    private UpstreamClient getUpstreamClient(UpstreamServer upstreamServer) {
        UpstreamClientFactory factory = (UpstreamClientFactory)this.clientFactoryTracker.getService();
        if (factory == null) {
            throw this.noMirrorPluginException();
        }
        return factory.create(upstreamServer);
    }

    private UpstreamServer getUpstreamServer() {
        UpstreamService upstreamService = (UpstreamService)this.upstreamServiceTracker.getService();
        if (upstreamService == null) {
            throw this.noMirrorPluginException();
        }
        UpstreamServer upstreamServer = upstreamService.get();
        if (upstreamServer == null || !IntegrationState.INSTALLED.equals((Object)upstreamServer.getState())) {
            throw this.noSuchUpstreamException();
        }
        return upstreamServer;
    }

    private MirrorPluginNotAvailableException noMirrorPluginException() {
        return new MirrorPluginNotAvailableException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.mirror.plugin.not.installed", new Object[0]));
    }

    private NoSuchUpstreamException noSuchUpstreamException() {
        return new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.not.yet.registered", new Object[0]));
    }
}

