/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.migration;

import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.migration.GitLfsSettingsMetadata;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.ObjectMapper;

public class GitLfsSettingsExporter
implements Exporter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final LfsService lfsService;

    public GitLfsSettingsExporter(LfsService lfsService) {
        this.lfsService = lfsService;
    }

    public void export(@Nonnull ExportContext context, @Nonnull Repository repository) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(repository, "repository");
        String repositoryId = context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)repository.getId());
        this.writeJson(context, Paths.get(repositoryId, "git-lfs-settings.json"), this.toGitLfsSettingsMetadata(repository));
    }

    private GitLfsSettingsMetadata toGitLfsSettingsMetadata(Repository repository) {
        return new GitLfsSettingsMetadata(this.lfsService.isEnabled(repository));
    }

    private void writeJson(ExportContext context, Path entryName, Object value) {
        context.addEntry(entryName, outputStream -> OBJECT_MAPPER.writeValue(outputStream, value), true);
    }
}

