/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.jwt;

import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.jwt.JwtIssuer;
import com.atlassian.jwt.JwtIssuerClaimVerifiersRegistry;
import com.atlassian.jwt.JwtIssuerRegistry;
import com.atlassian.jwt.reader.JwtClaimVerifiersBuilder;
import javax.annotation.Nonnull;

public class LfsJwtRegistry
implements JwtIssuerRegistry,
JwtIssuerClaimVerifiersRegistry {
    public static final String LFS_API_ISSUER_NAME = "com.atlassian.bitbucket.server.bitbucket-git-lfs";
    public static final String STORAGE_ISSUER_NAME = "com.atlassian.bitbucket.server.bitbucket-git-lfs-storage";
    private final JwtClaimVerifiersBuilder lfsApiClaimVerifiersBuilder;
    private final JwtIssuer lfsApiIssuer;
    private final JwtIssuer storageIssuer;

    public LfsJwtRegistry(JwtClaimVerifiersBuilder lfsApiClaimVerifiersBuilder, GitLfsSettingsService settingsService) {
        this.lfsApiClaimVerifiersBuilder = lfsApiClaimVerifiersBuilder;
        String sharedSecret = settingsService.getSharedSecret();
        this.lfsApiIssuer = new SimpleJwtIssuer(LFS_API_ISSUER_NAME, sharedSecret);
        this.storageIssuer = new SimpleJwtIssuer(STORAGE_ISSUER_NAME, sharedSecret);
    }

    public JwtClaimVerifiersBuilder getClaimVerifiersBuilder(@Nonnull String name) {
        return this.lfsApiIssuer.getName().equals(name) ? this.lfsApiClaimVerifiersBuilder : null;
    }

    public JwtIssuer getIssuer(@Nonnull String name) {
        if (this.lfsApiIssuer.getName().equals(name)) {
            return this.lfsApiIssuer;
        }
        if (this.storageIssuer.getName().equals(name)) {
            return this.storageIssuer;
        }
        return null;
    }

    private static class SimpleJwtIssuer
    implements JwtIssuer {
        private final String name;
        private final String sharedSecret;

        public SimpleJwtIssuer(String name, String sharedSecret) {
            this.name = name;
            this.sharedSecret = sharedSecret;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public String getSharedSecret() {
            return this.sharedSecret;
        }
    }
}

