/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.jwt;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.exception.JwtInvalidClaimException;
import com.atlassian.jwt.exception.JwtVerificationException;
import com.atlassian.jwt.reader.JwtClaimVerifier;
import com.atlassian.jwt.reader.JwtClaimVerifiersBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class GitLfsApiClaimVerifiersBuilder
implements JwtClaimVerifiersBuilder {
    private static final Pattern GIT_LFS_API_PATTERN = Pattern.compile("/scm/((?<namespace>[a-zA-Z0-9_\\-]*)/)?(?<projectKey>~?[a-zA-Z][a-zA-Z0-9_\\-]*)/(?<repoSlug>[\\p{Alnum}][\\w\\-\\.]*).git/info/lfs/.+");
    private final RepositorySupplier repositorySupplier;
    private final EscalatedSecurityContext withRepoRead;

    public GitLfsApiClaimVerifiersBuilder(RepositorySupplier repositorySupplier, SecurityService securityService) {
        this.repositorySupplier = repositorySupplier;
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "Validate Git LFS JWT");
    }

    public Map<String, ? extends JwtClaimVerifier> build(CanonicalHttpRequest request) {
        return ImmutableMap.of((Object)"repo", (Object)new GitLfsActionClaimVerifier(request));
    }

    private class GitLfsActionClaimVerifier
    implements JwtClaimVerifier {
        private final String relativePath;

        public GitLfsActionClaimVerifier(CanonicalHttpRequest request) {
            this.relativePath = request.getRelativePath();
        }

        public void verify(@Nonnull Object repoClaim) throws JwtVerificationException {
            String repoSlug;
            String projectKey;
            Matcher lfsApiMatcher = GIT_LFS_API_PATTERN.matcher(this.relativePath);
            if (!lfsApiMatcher.matches()) {
                throw new JwtInvalidClaimException("Invalid Git LFS path: " + this.relativePath);
            }
            String namespace = lfsApiMatcher.group("namespace");
            Repository repo = this.getRepositoryOrThrow(namespace, projectKey = lfsApiMatcher.group("projectKey"), repoSlug = lfsApiMatcher.group("repoSlug"));
            if (!Integer.toString(repo.getId()).equals(repoClaim.toString())) {
                throw new JwtInvalidClaimException(String.format("JWT repo claim (%s) does not match ID of repository in URL: %s", repoClaim, this.relativePath));
            }
        }

        @Nonnull
        private Repository getRepositoryOrThrow(String namespace, String projectKey, String repoSlug) throws JwtInvalidClaimException {
            Repository repository;
            try {
                repository = (Repository)GitLfsApiClaimVerifiersBuilder.this.withRepoRead.call(() -> GitLfsApiClaimVerifiersBuilder.this.repositorySupplier.getBySlug(namespace, projectKey, repoSlug));
            }
            catch (RepositoryMovedException e) {
                repository = e.getRepository();
            }
            if (repository == null) {
                throw new JwtInvalidClaimException("Invalid repository: " + this.relativePath);
            }
            return repository;
        }
    }
}

