/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.BaseLfsLockScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockDeletionRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLockDeletionRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfsLockDeleteScmRequest
extends BaseLfsLockScmRequest {
    private static final Logger log = LoggerFactory.getLogger(LfsLockDeleteScmRequest.class);
    private final String lockPath;
    private final Validator validator;

    public LfsLockDeleteScmRequest(@Nonnull AuthenticationContext authenticationContext, @Nonnull I18nService i18nService, @Nonnull LfsLockService lfsLockService, @Nonnull Repository repository, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Validator validator, @Nonnull String lockPath) {
        super(authenticationContext, i18nService, lfsLockService, repository, request, response);
        this.lockPath = lockPath;
        this.validator = Objects.requireNonNull(validator, "validator");
    }

    @Override
    protected void handleRequest(ObjectMapper mapper) throws IOException {
        Optional<Integer> lockId;
        RestLfsLockDeletionRequest deletionRequest = (RestLfsLockDeletionRequest)((Object)mapper.readValue((InputStream)this.request.getInputStream(), RestLfsLockDeletionRequest.class));
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)deletionRequest), (Class[])new Class[0]);
        Matcher lockDeleteMatcher = LfsHttpScmUtils.LFS_HTTP_LOCK_UNLOCK_PATH.matcher(this.lockPath);
        if (lockDeleteMatcher.matches() && (lockId = this.tryParseAsInt(lockDeleteMatcher.group("lockid"))).isPresent()) {
            LfsLock lock = this.lfsLockService.deleteLock(new LfsLockDeletionRequest.Builder(lockId.get(), this.repository).force(deletionRequest.isForce()).build());
            this.response.setStatus(200);
            try (ServletOutputStream outputStream = this.response.getOutputStream();){
                mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
                mapper.writeValue((OutputStream)outputStream, (Object)ImmutableMap.of((Object)"lock", (Object)((Object)new RestLfsLock(lock))));
            }
            return;
        }
        log.debug("{}: Unable to delete lock for path {}", (Object)this.repository, (Object)this.lockPath);
        LfsHttpScmUtils.sendError(this.response, 400, this.i18nService.getMessage("bitbucket.scm.git.lfs.lock.deletion.lockid.invalid", new Object[0]));
    }
}

