/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.BaseLfsHttpScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class BaseLfsLockScmRequest
extends BaseLfsHttpScmRequest {
    protected final LfsLockService lfsLockService;

    public BaseLfsLockScmRequest(@Nonnull AuthenticationContext authenticationContext, @Nonnull I18nService i18nService, @Nonnull LfsLockService lfsLockService, @Nonnull Repository repository, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        super(authenticationContext, request, response, i18nService, repository);
        this.lfsLockService = Objects.requireNonNull(lfsLockService, "lfsLockService");
    }

    public void handleRequest() throws IOException {
        ObjectMapper mapper = this.createMapper();
        try {
            this.response.setContentType("application/vnd.git-lfs+json; charset=utf-8");
            this.response.setHeader("Cache-Control", CachePolicies.noCache().toString());
            this.handleRequest(mapper);
        }
        catch (AuthorisationException e) {
            if (!this.authenticationContext.isAuthenticated()) {
                LfsHttpScmUtils.sendError(this.response, 401, this.i18nService.getMessage("bitbucket.scm.git.lfs.request.not.authenticated", new Object[0]));
            } else {
                LfsHttpScmUtils.sendError(this.response, (Exception)((Object)e));
            }
        }
        catch (RuntimeException e) {
            LfsHttpScmUtils.sendError(this.response, e);
        }
    }

    protected abstract void handleRequest(ObjectMapper var1) throws IOException;

    protected int getOrDefault(String parameter, int defaultValue) {
        return Optional.ofNullable(this.request.getParameter(parameter)).flatMap(this::tryParseAsInt).orElse(defaultValue);
    }

    protected Optional<Integer> tryParseAsInt(String value) {
        try {
            return value == null ? Optional.empty() : Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

