/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchRequestException;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsConstants;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsDisabledException;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ChecksumValidationException;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.InsufficientAvailableSpaceException;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.RangeNotSatisfiableException;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockConflictException;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockCreationException;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.ReadOnlyMirrorException;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.RestLfsError;
import com.atlassian.bitbucket.scm.http.HttpRequestDetails;
import com.atlassian.bitbucket.throttle.ResourceBusyException;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfsHttpScmUtils {
    public static final String LFS_HTTP_FRAG_EXT = "(?:\\.git)?";
    public static final String LFS_HTTP_FRAG_NAMESPACE = "/?((?<namespace>[^/']+)/)?";
    public static final String LFS_HTTP_FRAG_PROJECT = "(?<project>[^/]+)/";
    public static final String LFS_HTTP_FRAG_REPO = "(?<repo>[^/']+?)";
    public static final String LFS_HTTP_LOCK_FRAG_PATH = "(?<lockpath>/.+)?";
    public static final String LFS_HTTP_VERIFY_LOCK_PATH = "/verify";
    public static final Pattern LFS_HTTP_LOCK_UNLOCK_PATH = Pattern.compile("/(?<lockid>[^/]+)/unlock");
    public static final String LFS_HTTP_PATH = "/?((?<namespace>[^/']+)/)?(?<project>[^/]+)/(?<repo>[^/']+?)(?:\\.git)?";
    public static final Pattern LFS_HTTP_BATCH_PATH = Pattern.compile(String.format("%s/info/lfs/objects/batch", "/?((?<namespace>[^/']+)/)?(?<project>[^/]+)/(?<repo>[^/']+?)(?:\\.git)?"));
    public static final Pattern LFS_HTTP_LOCK_PATH = Pattern.compile(String.format("%s/info/lfs/locks%s", "/?((?<namespace>[^/']+)/)?(?<project>[^/]+)/(?<repo>[^/']+?)(?:\\.git)?", "(?<lockpath>/.+)?"));
    private static final JsonFactory JSON_FACTORY = new ObjectMapper().getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    private static final ImmutableMap<Class<? extends Exception>, Integer> STATUS_BY_EXCEPTION = ImmutableMap.builder().put(AuthenticationException.class, (Object)401).put(AuthorisationException.class, (Object)403).put(BadBatchRequestException.class, (Object)400).put(ChecksumValidationException.class, (Object)400).put(LfsLockConflictException.class, (Object)409).put(LfsLockCreationException.class, (Object)400).put(ReadOnlyMirrorException.class, (Object)400).put(GitLfsDisabledException.class, (Object)501).put(InsufficientAvailableSpaceException.class, (Object)503).put(JsonParseException.class, (Object)400).put(NoSuchEntityException.class, (Object)404).put(RangeNotSatisfiableException.class, (Object)416).put(ResourceBusyException.class, (Object)503).build();
    private static final Logger log = LoggerFactory.getLogger(LfsHttpScmUtils.class);

    public static boolean clientIsLfsConversant(@Nonnull HttpRequestDetails requestDetails) {
        return LfsHttpScmUtils.isGet(requestDetails) || LfsHttpScmUtils.clientIsSending(GitLfsConstants.LFS_MEDIA_TYPE, requestDetails) && LfsHttpScmUtils.clientCanReceive(GitLfsConstants.LFS_MEDIA_TYPE, requestDetails);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String entityFor(@Nonnull Exception exception) {
        RestLfsError error = new RestLfsError(exception);
        try (StringWriter writer = new StringWriter();){
            LfsHttpScmUtils.writeJsonError(writer, new RestLfsError(exception));
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            return String.format("{\"message\":\"%s\"}", error.get("message"));
        }
    }

    public static boolean isGet(@Nonnull HttpRequestDetails requestDetails) {
        return "GET".equalsIgnoreCase(requestDetails.getMethod());
    }

    public static boolean isLockApiCall(@Nonnull HttpRequestDetails requestDetails) {
        if (requestDetails.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = LFS_HTTP_LOCK_PATH.matcher(requestDetails.getPathInfo());
        if (!matcher.matches()) {
            return false;
        }
        if (!LfsHttpScmUtils.clientIsLfsConversant(requestDetails)) {
            return false;
        }
        String lockpath = matcher.group("lockpath");
        if (StringUtils.isEmpty((CharSequence)lockpath)) {
            return LfsHttpScmUtils.isPost(requestDetails) || LfsHttpScmUtils.isGet(requestDetails);
        }
        return LfsHttpScmUtils.isPost(requestDetails) && (LFS_HTTP_VERIFY_LOCK_PATH.equals(lockpath) || LFS_HTTP_LOCK_UNLOCK_PATH.matcher(lockpath).matches());
    }

    public static boolean isPost(@Nonnull HttpRequestDetails requestDetails) {
        return "POST".equals(requestDetails.getMethod());
    }

    public static void sendError(@Nonnull HttpServletResponse response, @Nonnull Exception exception) {
        Objects.requireNonNull(response, "response");
        Objects.requireNonNull(exception, "exception");
        LfsHttpScmUtils.sendError(response, LfsHttpScmUtils.statusFor(exception), new RestLfsError(exception));
    }

    public static void sendError(@Nonnull HttpServletResponse response, int statusCode, @Nonnull String message) {
        Objects.requireNonNull(response, "response");
        Objects.requireNonNull(message, "message");
        LfsHttpScmUtils.sendError(response, statusCode, new RestLfsError((Map<String, ?>)ImmutableMap.of((Object)"message", (Object)message)));
    }

    public static void sendErrorMessage(OutputStream outputStream, String message) {
        LfsHttpScmUtils.sendErrorMessage(outputStream, new RestLfsError((Map<String, ?>)ImmutableMap.of((Object)"message", (Object)message)));
    }

    public static int statusFor(Exception exception) {
        for (Map.Entry entry : STATUS_BY_EXCEPTION.entrySet()) {
            if (((Class)entry.getKey()).isInstance(exception)) {
                return (Integer)entry.getValue();
            }
            Throwable cause = exception.getCause();
            if (cause == null || !((Class)entry.getKey()).isInstance(cause)) continue;
            return (Integer)entry.getValue();
        }
        log.error("Un-mapped exception", (Throwable)exception);
        return 500;
    }

    private static boolean clientCanReceive(MediaType mediaType, HttpRequestDetails requestDetails) {
        return Optional.ofNullable(requestDetails.getHeader("Accept")).map(accept -> Splitter.on((char)',').splitToList((CharSequence)accept)).orElse(Collections.emptyList()).stream().anyMatch(accept -> {
            try {
                MediaType acceptType = MediaType.parse((String)accept);
                return acceptType.is(MediaType.ANY_TYPE) || acceptType.is(mediaType);
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    private static boolean clientIsSending(MediaType mediaType, @Nonnull HttpRequestDetails requestDetails) {
        return Optional.ofNullable(requestDetails.getContentType()).map(contentType -> {
            try {
                return MediaType.parse((String)contentType).is(mediaType);
            }
            catch (Exception e) {
                return false;
            }
        }).orElse(false);
    }

    private static void sendError(HttpServletResponse response, int statusCode, RestLfsError entity) {
        response.setContentType("application/vnd.git-lfs+json; charset=utf-8");
        response.setStatus(statusCode);
        try {
            LfsHttpScmUtils.sendErrorMessage((OutputStream)response.getOutputStream(), entity);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void sendErrorMessage(OutputStream outputStream, RestLfsError entity) {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, Charsets.UTF_8);){
            LfsHttpScmUtils.writeJsonError(writer, entity);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeJsonError(Writer writer, RestLfsError entity) throws IOException {
        try (JsonGenerator generator = JSON_FACTORY.createJsonGenerator(writer);){
            generator.writeObject((Object)entity);
            generator.flush();
        }
    }
}

