/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.scm.git.lfs.dao.AoLfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.dao.LfsLockDao;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class AoLfsLockDao
extends AbstractAoDao
implements LfsLockDao {
    AoLfsLockDao(@Nonnull ActiveObjects ao) {
        super(ao);
    }

    @VisibleForTesting
    public static String toRepositoryPathHash(int repositoryId, String path) {
        return String.format("%s#%s", repositoryId, DigestUtils.sha256Hex((String)path));
    }

    @Override
    @Nonnull
    public AoLfsLock create(@Nonnull ApplicationUser owner, @Nonnull String path, @Nonnull Repository repository) {
        Objects.requireNonNull(owner, "owner");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(repository, "repository");
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("Path must be non-blank");
        }
        return (AoLfsLock)this.ao.create(AoLfsLock.class, (Map)ImmutableMap.builder().put((Object)"DIRECTORY_HASH", (Object)DigestUtils.sha256Hex((String)FilenameUtils.getPathNoEndSeparator((String)path))).put((Object)"LOCKED_AT", (Object)new Date()).put((Object)"OWNER_ID", (Object)owner.getId()).put((Object)"PATH", (Object)path).put((Object)"REPOSITORY_ID", (Object)repository.getId()).put((Object)"REPO_PATH_HASH", (Object)AoLfsLockDao.toRepositoryPathHash(repository.getId(), path)).build());
    }

    @Override
    public void delete(@Nonnull AoLfsLock lock) {
        Objects.requireNonNull(lock, "lock");
        this.ao.delete(new RawEntity[]{lock});
    }

    @Override
    public void deleteByRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.ao.deleteWithSQL(AoLfsLock.class, "REPOSITORY_ID = ?", new Object[]{repository.getId()});
    }

    @Override
    @Nonnull
    public Page<AoLfsLock> findByRepository(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        Objects.requireNonNull(repository, "repository");
        return this.pageQuery(AoLfsLock.class, Query.select().where("REPOSITORY_ID = ?", new Object[]{repository.getId()}).order("ID"), pageRequest);
    }

    @Override
    @Nonnull
    public Page<AoLfsLock> findByRepositoryAndDirectory(@Nonnull Repository repository, @Nonnull String directory, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(directory, "directory");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Objects.requireNonNull(repository, "repository");
        return this.pageQuery(AoLfsLock.class, Query.select().where("REPOSITORY_ID = ? AND DIRECTORY_HASH = ?", new Object[]{repository.getId(), DigestUtils.sha256Hex((String)FilenameUtils.getPathNoEndSeparator((String)directory))}).order("ID"), pageRequest);
    }

    @Override
    @Nonnull
    public Optional<AoLfsLock> getById(int id) {
        return Optional.ofNullable(this.ao.get(AoLfsLock.class, (Object)id));
    }

    @Override
    @Nonnull
    public Optional<AoLfsLock> getByRepositoryAndPath(@Nonnull Repository repository, @Nonnull String path) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(repository, "repository");
        AoLfsLock[] existing = (AoLfsLock[])this.ao.find(AoLfsLock.class, Query.select().where("REPOSITORY_ID = ? and REPO_PATH_HASH = ?", new Object[]{repository.getId(), AoLfsLockDao.toRepositoryPathHash(repository.getId(), path)}));
        if (existing.length > 0 && path.equals(existing[0].getPath())) {
            return Optional.of(existing[0]);
        }
        return Optional.empty();
    }
}

