/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.atlassian.stash.internal.db.DatabaseAffixed;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Throwables;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class DelegatingSqlExceptionTranslator
implements DatabaseAffixed,
SQLExceptionTranslator {
    private final DataSource dataSource;
    private final ResettableLazyReference<SQLExceptionTranslator> translatorReference = new ResettableLazyReference<SQLExceptionTranslator>(){

        protected SQLExceptionTranslator create() throws Exception {
            return new SQLErrorCodeSQLExceptionTranslator(DelegatingSqlExceptionTranslator.this.dataSource);
        }
    };

    public DelegatingSqlExceptionTranslator(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void release() {
        this.translatorReference.reset();
    }

    public DataAccessException translate(String task, String sql, SQLException ex) {
        try {
            return ((SQLExceptionTranslator)this.translatorReference.get()).translate(task, sql, ex);
        }
        catch (LazyReference.InitializationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ExecutionException) {
                cause = cause.getCause();
            }
            Throwables.propagateIfPossible((Throwable)cause);
            throw e;
        }
    }
}

