/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.stash.internal.pull.AbstractPullRequestQueryHelper;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import javax.annotation.Nonnull;

public class PullRequestSearchQueryHelper
extends AbstractPullRequestQueryHelper {
    private static final String SELECT = "SELECT pr FROM InternalPullRequest pr ";
    private final StringBuilder selectBuilder = new StringBuilder("SELECT pr FROM InternalPullRequest pr ");
    private String orderBy;

    public PullRequestSearchQueryHelper(@Nonnull PullRequestSearchCriteria criteria) {
        super(criteria);
        this.setOrder(criteria.getOrder() == null ? PullRequestOrder.getDefaultOrder() : criteria.getOrder());
    }

    @Nonnull
    private PullRequestSearchQueryHelper setOrder(PullRequestOrder order) {
        switch (order) {
            case NEWEST: {
                this.orderBy = "ORDER BY pr.updatedDate desc";
                break;
            }
            case OLDEST: {
                this.orderBy = "ORDER BY pr.updatedDate asc";
                break;
            }
            case PARTICIPANT_STATUS: {
                this.orderBy = "ORDER BY st.weight asc, pr.updatedDate desc";
                this.selectBuilder.append(", InternalPullRequestParticipantStatusType st ");
                this.addConstraint("p0.status = st.id ");
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return this.selectBuilder + this.getJoinString() + this.getConstraintString() + this.orderBy;
    }
}

