/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="rescopeRequestDao")
public class HibernateRescopeRequestDao
extends AbstractHibernateDao<Long, InternalRescopeRequest>
implements RescopeRequestDao {
    @Autowired
    public HibernateRescopeRequestDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void deleteByIds(@Nonnull List<Long> requestIds) {
        for (List partition : Lists.partition(requestIds, (int)100)) {
            this.session().createQuery("delete from InternalRescopeRequest where id in (:ids)").setParameterList("ids", (Collection)partition).executeUpdate();
        }
    }

    @Nonnull
    public List<InternalRescopeRequest> findByRepository(int repositoryId) {
        return HibernateUtils.initializeList((List)this.session().createQuery("from InternalRescopeRequest where repository.id = :repositoryId order by id asc").setInteger("repositoryId", repositoryId).list());
    }

    @Nonnull
    public List<Integer> findPendingRepositoryIds() {
        return this.session().createQuery("select distinct repository.id from InternalRescopeRequest order by repository.id").list();
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"id"));
    }
}

