/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import java.util.Collection;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class SetMembershipAggregationChange
extends AbstractCustomChange
implements CustomTaskChange {
    private static final String SELECT_APPLICATION_ID = "SELECT id FROM cwd_application WHERE application_name = ?";
    private static final String SELECT_CLASHING_MEMBERSHIPS_IN_APPLICATION = "SELECT count(*) FROM ( SELECT m.membership_type AS membership_type, m.lower_child_name AS lower_child_name, count(DISTINCT m.directory_id) AS directory_count FROM cwd_membership m INNER JOIN cwd_app_dir_mapping a ON m.directory_id = a.directory_id INNER JOIN cwd_directory d ON m.directory_id = d.id WHERE a.application_id = ? AND d.is_active = 'T' GROUP BY m.membership_type, m.lower_child_name ) membership_counts WHERE directory_count > 1";
    private static final String INSERT_MEMBERSHIP_AGGREGATION = "INSERT INTO cwd_application_attribute (attribute_value, application_id, attribute_name) VALUES (?, ?, ?)";
    private static final String UPDATE_MEMBERSHIP_AGGREGATION = "UPDATE cwd_application_attribute SET attribute_value = ? WHERE application_id = ? AND attribute_name = ?";
    private static final Logger log = LoggerFactory.getLogger(SetMembershipAggregationChange.class);
    private int clashingMemberships;
    private Boolean membershipAggregationEnabled;
    private int rowsInserted;
    private int rowsUpdated;

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
        Long applicationId = this.getApplicationId(template);
        if (applicationId != null) {
            this.clashingMemberships = this.countClashingMemberships(template, applicationId);
            this.membershipAggregationEnabled = this.clashingMemberships == 0;
            this.setMembershipAggregationEnabled(template, applicationId, this.membershipAggregationEnabled);
            log.info(this.getConfirmationMessage());
        }
    }

    public String getConfirmationMessage() {
        if (this.membershipAggregationEnabled == null) {
            return "Membership aggregation was not modified as no application existed";
        }
        return "Membership aggregation was " + (this.membershipAggregationEnabled != false ? "enabled" : "disabled") + ". clashingMemberships = " + this.clashingMemberships + ", rowsInserted = " + this.rowsInserted + ", rowsUpdated = " + this.rowsUpdated;
    }

    private Long getApplicationId(JdbcTemplate template) {
        Number number = (Number)DataAccessUtils.singleResult((Collection)template.queryForList(SELECT_APPLICATION_ID, Number.class, new Object[]{"crowd-embedded"}));
        return number == null ? null : Long.valueOf(number.longValue());
    }

    private int countClashingMemberships(JdbcTemplate template, long applicationId) {
        Number result = (Number)template.queryForObject(SELECT_CLASHING_MEMBERSHIPS_IN_APPLICATION, Number.class, new Object[]{applicationId});
        return result.intValue();
    }

    private void setMembershipAggregationEnabled(JdbcTemplate template, long applicationId, boolean enabled) {
        this.rowsUpdated = template.update(UPDATE_MEMBERSHIP_AGGREGATION, new Object[]{Boolean.toString(enabled), applicationId, "aggregateMemberships"});
        if (this.rowsUpdated == 0) {
            this.rowsInserted = template.update(INSERT_MEMBERSHIP_AGGREGATION, new Object[]{Boolean.toString(enabled), applicationId, "aggregateMemberships"});
        }
    }
}

