/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class CrowdMembershipOrphanDedupeChange
extends AbstractCustomChange
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(CrowdMembershipOrphanDedupeChange.class);
    private int duplicatesDeleted;
    private int orphansDeleted;

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
        Collection<Long> orphans = this.findOrphans(template);
        log.debug("{} orphan cwd_membership rows found", (Object)orphans.size());
        if (!orphans.isEmpty()) {
            this.orphansDeleted = this.deleteRowsById(template, orphans);
            log.debug("Orphan cwd_membership rows deleted");
        }
        Collection<MembershipIndex> duplicateIndices = this.findDuplicateIndices(template);
        log.debug("{} duplicate cwd_membership indices found", (Object)duplicateIndices.size());
        if (!duplicateIndices.isEmpty()) {
            this.duplicatesDeleted = this.deleteRowsByIndices(template, duplicateIndices);
            log.debug("Duplicate cwd_membership rows deleted");
        }
    }

    private int deleteRowsById(JdbcTemplate template, Collection<Long> rowIdsToDelete) throws CustomChangeException {
        int rowsDeleted = 0;
        try {
            Iterable batches = Iterables.partition(rowIdsToDelete, (int)100);
            for (List idsToRemove : batches) {
                rowsDeleted += template.update("DELETE FROM cwd_membership WHERE id IN ( " + Joiner.on((char)',').join((Iterable)idsToRemove) + " )");
            }
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Failed to delete some cwd_membership rows", (Throwable)e);
        }
        return rowsDeleted;
    }

    private int deleteRowsByIndices(JdbcTemplate template, Collection<MembershipIndex> indices) throws CustomChangeException {
        int rowsDeleted = 0;
        try {
            Iterable batches = Iterables.partition(indices, (int)25);
            for (final List indicesToRemove : batches) {
                rowsDeleted += template.batchUpdate("DELETE FROM cwd_membership WHERE directory_id = ? AND lower_parent_name = ? AND lower_child_name = ? AND membership_type = ?", new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        ps.setLong(1, ((MembershipIndex)indicesToRemove.get(i)).directoryId);
                        ps.setString(2, ((MembershipIndex)indicesToRemove.get(i)).lowerParentName);
                        ps.setString(3, ((MembershipIndex)indicesToRemove.get(i)).lowerChildName);
                        ps.setString(4, ((MembershipIndex)indicesToRemove.get(i)).membershipType);
                    }

                    public int getBatchSize() {
                        return indicesToRemove.size();
                    }
                })[0];
            }
        }
        catch (DataAccessException e) {
            log.error("Failed to delete some cwd_membership rows", (Throwable)e);
            throw new CustomChangeException("Failed to delete some cwd_membership rows", (Throwable)e);
        }
        return rowsDeleted;
    }

    private Collection<MembershipIndex> findDuplicateIndices(JdbcTemplate template) throws CustomChangeException {
        try {
            List duplicateIndices = template.query("SELECT directory_id, lower_parent_name, lower_child_name, membership_type, COUNT(*) as cn FROM cwd_membership GROUP BY directory_id, lower_parent_name, lower_child_name, membership_type HAVING COUNT(*) > 1", (RowMapper)new MembershipIndexMapper());
            return duplicateIndices;
        }
        catch (DataAccessException e) {
            log.error("Failed to query cwd_membership for orphans", (Throwable)e);
            throw new CustomChangeException("Failed to query cwd_membership for orphans", (Throwable)e);
        }
    }

    private Collection<Long> findOrphans(JdbcTemplate template) throws CustomChangeException {
        try {
            List orphans = template.query("SELECT cwd_membership.id FROM cwd_membership LEFT JOIN cwd_user ON cwd_membership.child_id = cwd_user.id LEFT JOIN cwd_group ON cwd_membership.parent_id = cwd_group.id WHERE cwd_membership.membership_type = 'GROUP_USER' AND (cwd_user.id IS NULL OR cwd_group.id IS NULL)", (RowMapper)new IdMapper());
            return orphans;
        }
        catch (DataAccessException e) {
            log.error("Failed to query cwd_membership for orphans", (Throwable)e);
            throw new CustomChangeException("Failed to query cwd_membership for orphans", (Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return "Orphans and duplicate entries in cwd_membership removed. Orphans = " + this.orphansDeleted + " Duplicates = " + this.duplicatesDeleted + ".";
    }

    private static class MembershipIndexMapper
    implements RowMapper<MembershipIndex> {
        private MembershipIndexMapper() {
        }

        public MembershipIndex mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new MembershipIndex(rs.getLong("directory_id"), rs.getString("lower_parent_name"), rs.getString("lower_child_name"), rs.getString("membership_type"));
        }
    }

    private static class MembershipIndex {
        private final long directoryId;
        private final String lowerParentName;
        private final String lowerChildName;
        private final String membershipType;

        private MembershipIndex(long directoryId, String lowerParentName, String lowerChildName, String membershipType) {
            this.directoryId = directoryId;
            this.lowerParentName = lowerParentName;
            this.lowerChildName = lowerChildName;
            this.membershipType = membershipType;
        }
    }

    private static class IdMapper
    implements RowMapper<Long> {
        private IdMapper() {
        }

        public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getLong("id");
        }
    }
}

