/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchProcessor;
import com.atlassian.stash.internal.crowd.BatchTransaction;
import com.atlassian.stash.internal.crowd.BatchTransactionSupplier;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class TransactionManagerBatchProcessor
extends AbstractBatchProcessor<Session> {
    private final SessionFactory sessionFactory;
    private final ThreadLocal<BatchTransaction> transactionHolder;
    private final BatchTransactionSupplier transactionSupplier;

    public TransactionManagerBatchProcessor(SessionFactory sessionFactory, BatchTransactionSupplier transactionSupplier) {
        this.sessionFactory = sessionFactory;
        this.transactionSupplier = transactionSupplier;
        this.transactionHolder = new ThreadLocal();
    }

    protected void afterProcessBatch() {
        this.commitTransaction();
    }

    protected void afterProcessCollection() {
    }

    protected void afterProcessIndividual() {
        this.commitTransaction();
    }

    protected void beforeProcessBatch() {
        this.startTransaction();
    }

    protected void beforeProcessIndividual() {
        this.startTransaction();
    }

    protected void beforeProcessCollection() {
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected void rollbackProcessBatch() {
        this.rollbackTransaction();
    }

    protected void rollbackProcessIndividual() {
        this.rollbackTransaction();
    }

    private void clearTransaction() {
        this.transactionHolder.remove();
    }

    private void commitTransaction() {
        this.getTransactionOrFail().commit();
        this.clearTransaction();
    }

    private void rollbackTransaction() {
        this.getTransactionOrFail().rollback();
        this.clearTransaction();
    }

    private void startTransaction() {
        Preconditions.checkState((this.transactionHolder.get() == null ? 1 : 0) != 0, (Object)"No transaction should be active");
        this.transactionHolder.set((BatchTransaction)this.transactionSupplier.get());
        Session session = this.sessionFactory.getCurrentSession();
        session.setCacheMode(CacheMode.IGNORE);
    }

    @Nonnull
    private BatchTransaction getTransactionOrFail() {
        BatchTransaction transaction = this.transactionHolder.get();
        Preconditions.checkState((transaction != null ? 1 : 0) != 0, (Object)"A transaction should be active");
        return transaction;
    }
}

