/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.stash.internal.crowd.BatchTransaction;
import com.atlassian.stash.internal.crowd.BatchTransactionSupplier;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringBatchTransactionSupplier
implements BatchTransactionSupplier {
    private static final Logger log = LoggerFactory.getLogger(SpringBatchTransactionSupplier.class);
    private final PlatformTransactionManager transactionManager;

    public SpringBatchTransactionSupplier(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public BatchTransaction get() {
        TransactionStatus status = this.transactionManager.getTransaction(SpringTransactionUtils.REQUIRES_NEW);
        SynchronizationBatchTransaction transaction = new SynchronizationBatchTransaction(status);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)transaction);
        return transaction;
    }

    private void doCommit(TransactionStatus transaction) {
        log.trace("{} is being committed", (Object)transaction);
        this.transactionManager.commit(transaction);
        log.trace("{} has been committed", (Object)transaction);
    }

    private void doRollback(TransactionStatus transaction) {
        log.trace("{} is being rolled back", (Object)transaction);
        this.transactionManager.rollback(transaction);
        log.trace("{} has been rolled back", (Object)transaction);
    }

    private class SynchronizationBatchTransaction
    extends TransactionSynchronizationAdapter
    implements BatchTransaction {
        private final TransactionStatus transaction;
        private boolean rolledBack;
        private String toString;

        public SynchronizationBatchTransaction(TransactionStatus transaction) {
            this.transaction = transaction;
        }

        public void afterCompletion(int status) {
            String code;
            if (status == 0) {
                code = "COMMITTED";
            } else {
                this.rolledBack = true;
                code = status == 1 ? "ROLLED BACK" : "UNKNOWN";
            }
            log.debug("{} has completed: {} ({})", new Object[]{this, code, status});
        }

        @Override
        public void commit() {
            SpringBatchTransactionSupplier.this.doCommit(this.transaction);
        }

        @Override
        public void rollback() {
            if (this.rolledBack) {
                log.warn("{} has already been rolled back", (Object)this);
            } else {
                SpringBatchTransactionSupplier.this.doRollback(this.transaction);
            }
        }

        public String toString() {
            if (this.toString == null) {
                String value = this.transaction.toString();
                int index = value.indexOf(64);
                this.toString = "Transaction " + (index == -1 ? value : value.substring(index + 1));
            }
            return this.toString;
        }
    }
}

