/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.application.ApplicationDAOHibernate;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import java.util.List;
import org.hibernate.Hibernate;

public class HibernateApplicationDao
extends ApplicationDAOHibernate
implements ApplicationDAO {
    public List<Application> findAuthorisedApplications(long directoryId, List<String> groupNames) {
        return HibernateApplicationDao.initialize(super.findAuthorisedApplications(directoryId, groupNames));
    }

    public ApplicationImpl findById(long id) throws ApplicationNotFoundException {
        return HibernateApplicationDao.initialize(super.findById(id));
    }

    public ApplicationImpl findByName(String name) throws ApplicationNotFoundException {
        return HibernateApplicationDao.initialize(super.findByName(name));
    }

    public Object load(long ID) throws ObjectNotFoundException {
        return HibernateApplicationDao.initialize((ApplicationImpl)ApplicationImpl.class.cast(super.load(ID)));
    }

    public Object loadReference(long id) {
        return HibernateApplicationDao.initialize((ApplicationImpl)ApplicationImpl.class.cast(super.loadReference(id)));
    }

    public List<Application> search(EntityQuery<Application> query) {
        return HibernateApplicationDao.initialize(super.search(query));
    }

    static ApplicationImpl initialize(ApplicationImpl application) {
        if (application != null) {
            Hibernate.initialize((Object)application.getAttributes());
            for (DirectoryMapping mapping : application.getDirectoryMappings()) {
                Hibernate.initialize((Object)mapping.getApplication());
                Hibernate.initialize((Object)mapping.getAllowedOperations());
                Hibernate.initialize((Object)mapping.getAuthorisedGroups());
                HibernateDirectoryDao.initialize((DirectoryImpl)DirectoryImpl.class.cast(mapping.getDirectory()));
                for (GroupMapping groupMapping : mapping.getAuthorisedGroups()) {
                    Hibernate.initialize((Object)groupMapping.getApplication());
                    Hibernate.initialize((Object)groupMapping.getDirectoryMapping());
                    Hibernate.initialize((Object)groupMapping.getDirectory());
                }
            }
            Hibernate.initialize((Object)application.getRemoteAddresses());
        }
        return application;
    }

    static List<Application> initialize(List<Application> applications) {
        for (Application application : applications) {
            HibernateApplicationDao.initialize((ApplicationImpl)ApplicationImpl.class.cast(application));
        }
        return applications;
    }
}

