/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.bitbucket.idx.IndexSearchRequest;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.content.IndexedCommitDao;
import com.atlassian.stash.internal.idx.InternalCommitAttribute;
import com.atlassian.stash.internal.idx.InternalIndexedCommit;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="indexedCommitDao")
public class HibernateIndexedCommitDao
extends AbstractHibernateDao<String, InternalIndexedCommit>
implements IndexedCommitDao {
    @Autowired
    public HibernateIndexedCommitDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean addMembership(@Nonnull InternalIndexedCommit commit, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(commit.getId(), repository);
        if (membership == null) {
            this.session().save((Object)new InternalRepositoryMembership(commit, repository));
            return true;
        }
        return false;
    }

    public boolean addProperty(@Nonnull InternalIndexedCommit commit, @Nonnull String key, @Nonnull String value) {
        boolean result = commit.addAttribute(new InternalCommitAttribute(key, value));
        this.session().update((Object)commit);
        return result;
    }

    public void deleteAllMemberships(@Nonnull InternalRepository repository) {
        this.session().createQuery("DELETE from InternalRepositoryMembership where repository = :repositoryId").setParameter("repositoryId", (Object)repository).executeUpdate();
    }

    public boolean deleteMembership(@Nonnull String commitId, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(commitId, repository);
        if (membership != null) {
            this.session().delete((Object)membership);
            InternalIndexedCommit commit = membership.getCommit();
            Set memberships = commit.getRepositoryMemberships();
            memberships.remove(membership);
            if (memberships.isEmpty()) {
                this.delete(membership.getCommit());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Page<InternalIndexedCommit> findByProperty(String key, String value, boolean caseSensitive, PageRequest pageRequest) {
        return HibernateUtils.initializePage(this.pageQuery(this.session().createQuery("FROM InternalIndexedCommit c JOIN c.attributes att WITH " + (caseSensitive ? "att.value = :value " : "lower(att.value) = lower(:value) ") + " AND att.name = :name " + "ORDER BY c.authorTimestamp DESC").setString("name", key).setString("value", value), pageRequest));
    }

    @Nonnull
    public PropertyMap getProperties(String commitId, Iterable<String> propertyKeys) {
        if (commitId == null || Iterables.isEmpty(propertyKeys)) {
            return PropertyMap.EMPTY;
        }
        List attributes = this.session().createQuery("SELECT new com.atlassian.stash.internal.idx.InternalCommitAttribute(att.name, att.value) FROM InternalIndexedCommit c JOIN c.attributes att WITH att.name IN (:names) WHERE c.id = :id").setString("id", commitId).setParameterList("names", HibernateIndexedCommitDao.asSet(propertyKeys)).list();
        PropertyAccumulator properties = new PropertyAccumulator();
        for (InternalCommitAttribute attribute : attributes) {
            properties.add(attribute.getName(), attribute.getValue());
        }
        return properties.toProperties();
    }

    @Nonnull
    public Map<String, PropertyMap> getProperties(Iterable<String> commitIds, Iterable<String> propertyKeys) {
        if (Iterables.isEmpty(commitIds) || Iterables.isEmpty(propertyKeys)) {
            return Collections.emptyMap();
        }
        List results = this.session().createQuery("SELECT c.id, att.name, att.value FROM InternalIndexedCommit c JOIN c.attributes att WITH att.name IN (:names) WHERE c.id IN (:ids)").setParameterList("ids", HibernateIndexedCommitDao.asSet(commitIds)).setParameterList("names", HibernateIndexedCommitDao.asSet(propertyKeys)).list();
        HashMap resultBuilder = Maps.newHashMap();
        for (Object[] row : results) {
            String commitId = (String)row[0];
            String name = (String)row[1];
            String value = (String)row[2];
            PropertyAccumulator properties = (PropertyAccumulator)resultBuilder.get(commitId);
            if (properties == null) {
                properties = new PropertyAccumulator();
                resultBuilder.put(commitId, properties);
            }
            properties.add(name, value);
        }
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)resultBuilder, PropertyAccumulator.TO_PROPERTIES));
    }

    @Nonnull
    public Set<String> getPropertyValues(String commitId, String key) {
        PropertyMap result = this.getProperties(commitId, Collections.singleton(key));
        return result.isEmpty() ? Collections.emptySet() : (Set)result.getAs(key, Set.class, String.class);
    }

    public boolean isIndexed(@Nonnull String commitId, @Nonnull InternalRepository repository) {
        return this.getMembership(commitId, repository) != null;
    }

    public boolean removeProperty(@Nonnull String commitId, @Nonnull String key, @Nonnull String value) {
        InternalIndexedCommit commit = (InternalIndexedCommit)this.getById(commitId);
        if (commit != null) {
            boolean result = commit.removeAttribute(new InternalCommitAttribute(key, value));
            this.session().update((Object)commit);
            return result;
        }
        return false;
    }

    @Nonnull
    public Page<InternalIndexedCommit> search(@Nonnull IndexSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalIndexedCommit.class);
        if (StringUtils.isNotEmpty((CharSequence)searchRequest.getFilter())) {
            criteria.add((Criterion)Restrictions.like((String)"id", (String)searchRequest.getFilter(), (MatchMode)MatchMode.START));
        }
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest));
    }

    @Override
    public InternalIndexedCommit update(InternalIndexedCommit entity) {
        throw new UnsupportedOperationException("Indexed commits can not be updated");
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Arrays.asList(Order.desc((String)"authorTimestamp"), Order.desc((String)"id"));
    }

    private static Set<String> asSet(Iterable<String> values) {
        return values instanceof Set ? (Set)values : ImmutableSet.copyOf(values);
    }

    private InternalRepositoryMembership getMembership(@Nonnull String commitId, @Nonnull InternalRepository repository) {
        return (InternalRepositoryMembership)this.session().get(InternalRepositoryMembership.class, (Serializable)new InternalRepositoryMembership.PK(commitId, repository.getId()));
    }

    private static class PropertyAccumulator {
        static final Function<PropertyAccumulator, PropertyMap> TO_PROPERTIES = new Function<PropertyAccumulator, PropertyMap>(){

            public PropertyMap apply(PropertyAccumulator input) {
                return input.toProperties();
            }
        };
        private final Map<String, Set<String>> properties = new HashMap<String, Set<String>>();

        private PropertyAccumulator() {
        }

        public void add(String key, String value) {
            Set<String> values = this.properties.get(key);
            if (values == null) {
                values = new HashSet<String>();
                this.properties.put(key, values);
            }
            values.add(value);
        }

        public PropertyMap toProperties() {
            return new PropertyMap.Builder().properties(this.properties).build();
        }
    }
}

